<?php
   ini_set("display_errors",1);
   error_reporting(E_ALL);
   include_once($_SERVER['DOCUMENT_ROOT'] . '/send-mail/sendEmailCronError.php');
   include './config.php';
   set_time_limit(300);
   $start_time = microtime(true);
   
   
   // below code is used for giving the manual url for running cron
  $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
  $root_url = $protocol . "://" . $_SERVER['HTTP_HOST']; 
  $current_directory = $root_url . dirname($_SERVER['PHP_SELF']);
  $manual_cron_url = $current_directory.'/jobdiva_fetch_jobs_cron.php';

  $total_actual_fetched = 0;

   $authentication_url = "https://api.jobdiva.com/api/authenticate?clientid=" . urlencode($jobdiva_clientId) . "&username=" . urlencode($jobdiva_username) . "&password=" . urlencode($jobdiva_password);


    // Initialize cURL authentication session
    $ch_auth = curl_init();
    curl_setopt($ch_auth, CURLOPT_URL, $authentication_url);
    curl_setopt($ch_auth, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_auth, CURLOPT_HTTPHEADER, array(
        'accept: */*',
        'X-CSRF-TOKEN: fb74f218-389d-4976-aecc-a3fde1302600'
    )); 

    // Execute auth cURL session
    $auth_token = curl_exec($ch_auth);
    
     if ($auth_token === false) {
        $error_message = "Authentication cURL error: " . curl_error($ch_auth);
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }

    // API Call to get the jobtitle and job id
    $api_url = 'https://api.jobdiva.com/api/bi/PortalJobsList?portalID='.$jobDivaPortalId;

    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: ' .$auth_token,
        'X-CSRF-TOKEN: 13edf39f-7f18-4b82-86c3-904c2fb2dd89'
    )); 

    // Execute cURL session
    $api_response = curl_exec($ch);
    
    
     if ($api_response === false) {
        $error_message = "Jobs List cURL error: " . curl_error($ch);
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }

    $dataIds = json_decode($api_response, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error_message = "JSON decode error: " . json_last_error_msg();
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }

    // var_dump($dataIds);
    // echo "----------------------------------------------";
    // die;

    if(isset($dataIds['status']) && $dataIds['status'] == 401){
        $error_message = "API Authentication Failed: " . $dataIds['message'];
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }

    $jobIds = [];

    foreach (array_slice($dataIds['data'], 1) as $single_data) {
        $jobIds[] = $single_data[0];
    }
    


    // print_r($jobIds);

    curl_close($ch); // Close the initial cURL session

    // Connect to the database
    $conn = new mysqli($servername, $username, $password, $database_name);
   if ($conn->connect_error) {
        $error_message = "Database connection failed: " . $conn->connect_error;
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }

    

   

    // Define table name and columns
    $table_name = $table_name_jobdiva;
    $columns = [
        "id" => "INT",
        "dateIssued" => "DATETIME",
        "dateUpdated" => "DATETIME",
        "dateUserFieldUpdated" => "DATETIME",
        "dateStatusUpdated" => "DATETIME",
        "jobStatus" => "VARCHAR(50)",
        "customerId" => "INT",
        "companyId" => "INT",
        "address1" => "VARCHAR(255)",
        "address2" => "VARCHAR(255)",
        "city" => "VARCHAR(100)",
        "state" => "VARCHAR(100)",
        "zipCode" => "VARCHAR(20)",
        "country" => "VARCHAR(100)",
        "priority" => "VARCHAR(50)",
        "division" => "VARCHAR(100)",
        "refNo" => "VARCHAR(50)",
        "jobDivaNo" => "VARCHAR(50)",
        "startDate" => "DATE",
        "endDate" => "DATE",
        "positions" => "INT",
        "fills" => "INT",
        "maxAllowedSubmittals" => "INT",
        "billRateMin" => "DECIMAL(10, 2)",
        "billRateMax" => "DECIMAL(10, 2)",
        "billRatePer" => "VARCHAR(50)",
        "payRateMin" => "DECIMAL(10, 2)",
        "payRateMax" => "DECIMAL(10, 2)",
        "payRatePer" => "VARCHAR(50)",
        "positionType" => "VARCHAR(50)",
        "skills" => "TEXT",
        "jobTitle" => "VARCHAR(255)",
        "jobDescription" => "TEXT",
        "remarks" => "TEXT",
        "submittalInstruction" => "TEXT",
        "postToPortal" => "BOOLEAN",
        "postingTitle" => "VARCHAR(255)",
        "postingDate" => "DATE",
        "postingDescription" => "TEXT",
        "criteriaDegree" => "VARCHAR(50)",
        "jobCatalogId" => "INT",
        "catalogCompanyId" => "INT",
        "catalogTitle" => "VARCHAR(255)",
        "catalogRefNo" => "VARCHAR(50)",
        "catalogName" => "VARCHAR(255)",
        "catalogActive" => "BOOLEAN",
        "catalogEffectiveDate" => "DATE",
        "catalogExpirationDate" => "DATE",
        "catalogCategory" => "VARCHAR(100)",
        "catalogBillRateLow" => "DECIMAL(10, 2)",
        "catalogBillRateHigh" => "DECIMAL(10, 2)",
        "catalogBillRatePer" => "VARCHAR(50)",
        "catalogPayRateLow" => "DECIMAL(10, 2)",
        "catalogPayRateHigh" => "DECIMAL(10, 2)",
        "catalogPayRatePer" => "VARCHAR(50)",
        "positionRefNo" => "VARCHAR(50)",
        "preventLowerPay" => "BOOLEAN",
        "preventHigherBill" => "BOOLEAN",
        "catalogNotes" => "TEXT",
        "ot" => "BOOLEAN",
        "references" => "TEXT",
        "travel" => "BOOLEAN",
        "drugTest" => "BOOLEAN",
        "backgroundCheck" => "BOOLEAN",
        "securityClearance" => "VARCHAR(100)",
        "onsiteFlexibility" => "VARCHAR(50)",
        "remotePercentage" => "INT",
        "fee" => "DECIMAL(10, 2)",
        "feeType" => "VARCHAR(50)",
        "jobCategory" => "VARCHAR(100)",
        "postingCity" => "VARCHAR(100)",
        "postingState" => "VARCHAR(100)",
        "postingZipCode" => "VARCHAR(20)",
        "postingCountry" => "VARCHAR(100)",
        "requiredCountry" => "VARCHAR(100)",
        "requiredState" => "VARCHAR(100)",
        "requiredAreaCodes" => "VARCHAR(100)",
        "requiredZipCode" => "VARCHAR(20)",
        "requiredWithin" => "INT",
        "requiredPayRangeFrom" => "DECIMAL(10, 2)",
        "requiredPayRangeTo" => "DECIMAL(10, 2)",
        "requiredPayRangePer" => "VARCHAR(50)",
        "requiredMajor" => "VARCHAR(100)",
        "requiredDegree" => "VARCHAR(100)"
    ];


    // Add missing columns if necessary
    $addColumnsResult = addMissingColumns($conn, $table_name, $columns);

    if ($addColumnsResult !== true) {
        $error_message = "Database column addition failed: " . $addColumnsResult;
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }
    // Function to add missing columns to the table end ---------------------


    // Prepare statement for inserting data
    $columnsList = array_keys($columns);


    $placeholders = rtrim(str_repeat("?, ", count($columns)), ", ");


    $sql = "INSERT INTO `$table_name` (`" . implode("`, `", $columnsList) . "`) VALUES ($placeholders)";

    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        $error_message = "Prepare statement failed: " . $conn->error;
        sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
        die($error_message);
    }


    
    $total_actual_fetched = count($jobIds);
    // Loop through each job ID to get the data of each job
    
    
    foreach ($jobIds as $jobId) {
        
        $api_url_for_job = 'https://api.jobdiva.com/api/bi/JobsDetail?jobIds=' . urlencode($jobId);
        
        // Initialize cURL session for each job ID
        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, $api_url_for_job);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_HTTPHEADER, array(
            'Accept: application/json',
            'Authorization: ' . $auth_token,
            'X-CSRF-TOKEN: 13edf39f-7f18-4b82-86c3-904c2fb2dd89'
        ));
        
        // Execute cURL session
        $api_response_for_job = curl_exec($ch2);
        
        // Check for errors in cURL execution
        if ($api_response_for_job === false) {
            $error_message = "Job details cURL error for job $jobId: " . curl_error($ch2);
            sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
            curl_close($ch2);
            continue;
        }
        
        // Close cURL session
        curl_close($ch2);
        
        // Decode JSON response
        $data = json_decode($api_response_for_job, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            $error_message = "JSON decode error for job $jobId: " . json_last_error_msg();
            sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
            continue;
        }
        
        if (!isset($data['data'])) {
            continue; // Skip if no data
        }
    
        $jobStatus = $data['data'][1][5];
        
        // print_r($data['data']);
        // die;
        
        // Prepare the statement for checking existing job
        $check_sql = "SELECT COUNT(*) FROM `$table_name` WHERE `id` = ?";
        $check_stmt = $conn->prepare($check_sql);
        
        if (!$check_stmt) {
            $error_message = "Prepare statement failed for checking job $jobId: " . $conn->error;
            sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
            continue;
        }
        
        // Bind and execute the check statement
        $check_stmt->bind_param("s", $jobId);
        if (!$check_stmt->execute()) {
            $error_message = "Execute failed for checking job $jobId: " . $check_stmt->error;
            sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
            $check_stmt->close();
            continue;
        }
        
        $check_stmt->bind_result($count);
        $check_stmt->fetch();
        $check_stmt->close();
        
        // If job exists, delete it first
        if ($count > 0) {
            $delete_sql = "DELETE FROM `$table_name` WHERE `id` = ?";
            $delete_stmt = $conn->prepare($delete_sql);
            
            if (!$delete_stmt) {
                $error_message = "Prepare statement failed for deleting job $jobId: " . $conn->error;
                sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
                continue;
            }
            
            $delete_stmt->bind_param("s", $jobId);
            if (!$delete_stmt->execute()) {
                $error_message = "Execute failed for deleting job $jobId: " . $delete_stmt->error;
                sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
                $delete_stmt->close();
                continue;
            }
            $delete_stmt->close();
        }
        
        // Prepare the statement for inserting data
        $columnsList = array_keys($columns);
        $placeholders = rtrim(str_repeat("?, ", count($columnsList)), ", ");
        $sql = "INSERT INTO `$table_name` (`" . implode("`, `", $columnsList) . "`) VALUES ($placeholders)";
        $stmt = $conn->prepare($sql);
        
        if (!$stmt) {
            $error_message = "Prepare statement failed for inserting job $jobId: " . $conn->error;
            sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
            continue;
        }
        
        // Bind parameters and insert data
       foreach (array_slice($data['data'], 1) as $job) { // Skip the first element if it contains column names
              $params = array_values($job);

              // Assuming job ID is the first column, adjust index if necessary
              $jobId = $params[0] ?? 'Unknown';

              // Replace empty strings with null and determine parameter types
              $param_types = "";
              foreach ($params as $key => $value) {
                  if ($value === '') {
                      $params[$key] = null;
                  }

                  // Determine type (i = integer, d = double, s = string, b = blob)
                  if (is_int($params[$key])) {
                      $param_types .= "i";
                  } elseif (is_float($params[$key])) {
                      $param_types .= "d";
                  } elseif (is_null($params[$key])) {
                      $param_types .= "s"; // NULLs are typically treated as strings
                  } else {
                      $param_types .= "s";
                  }
              }

              // Bind parameters dynamically
              if (!$stmt->bind_param($param_types, ...$params)) {
                  $error_message = "Binding parameters failed for job ID $jobId: " . $stmt->error;
                  sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
                  continue;
              }

              // Execute statement
              if (!$stmt->execute()) {
                  $error_message = "Execution failed for inserting job ID $jobId: " . $stmt->error;
                  sendErrorMailForCron('Job Fetch', $instance, $manual_cron_url, $error_message);
                  continue;
              }
         }

        
        $stmt->close();
    }
    
    
    // Close statement and database connection
   
    $conn->close();
    $end_time = microtime(true);
    $execution_time = $end_time - $start_time;
       
    
    // Prepare success message
    $log_message = json_encode([
            "status" => "success",
            "message" => "Jobs fetched and saved in database successfully from jobdiva",
            "instance" => $instance,
            "total jobs fetched" => $total_actual_fetched,
            "execution_time" => "".round($execution_time)." seconds"
    ], JSON_PRETTY_PRINT);
    
    
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[$timestamp] $log_message" . PHP_EOL;
    
    // Write the log entry
    file_put_contents($_SERVER['DOCUMENT_ROOT']. '/cron_logs/jobdiva.log', $log_entry, FILE_APPEND);
        
    
    // Return the response as JSON
    echo $log_message;






// Function to add missing columns to the table start ---------------------
 function addMissingColumns($conn, $table_name, $columns) {
        $existing_columns = [];
        $result = $conn->query("SHOW COLUMNS FROM `$table_name`");

        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $existing_columns[$row['Field']] = $row['Type'];
            }
        }

        $errors = [];
        foreach ($columns as $column => $type) {
            if (!array_key_exists($column, $existing_columns)) {
                $sql = "ALTER TABLE `$table_name` ADD COLUMN `$column` $type";
                if (!$conn->query($sql)) {
                    $errors[] = "Error adding column `$column` with type `$type`: " . $conn->error;
                }
            }
        }
        
        return empty($errors) ? true : $errors;
    }

    ?>
