<?php
include './config.php';

ini_set("display_errors",1);
error_reporting(E_ALL);

// Database credentials
$dbname = $database_name;

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}






$parts = explode('-', $instance);
$country = $parts[0]; // "usa"

$categoriesQuery = "SELECT DISTINCT jobTitle FROM $table_name_jobdiva WHERE jobStatus = 'OPEN'";
$locationQuery = "SELECT DISTINCT postingCity, postingState, postingCountry FROM $table_name_jobdiva WHERE jobStatus = 'OPEN'";

if ($country === 'usa') {
    $country = "US";
    $categoriesQuery .= " AND country = '$country'";
    $locationQuery .= " AND country = '$country'";
} elseif ($country === 'canada') {
    $country = "CA";
    $categoriesQuery .= " AND country = '$country'";
    $locationQuery .= " AND country = '$country'";
}



$categoriesResult = $conn->query($categoriesQuery);
$locationResult = $conn->query($locationQuery);


if (!$categoriesResult || !$locationResult ) {
    die(json_encode(["error" => "Query failed: " . $conn->error]));
}

$categories = [];


while ($row = $categoriesResult->fetch_assoc()) {
    if (!empty($row['jobTitle'])) {
        $categories[] = $row['jobTitle'];
    }
}

$statesWithCities = [];

while ($row = $locationResult->fetch_assoc()) {
    $city = trim($row['postingCity'] ?? '');
    $state = trim($row['postingState'] ?? '');
    $country = trim($row['postingCountry'] ?? '');

    if (!empty($state) && !empty($city)) {
        if (!isset($statesWithCities[$state])) {
            $statesWithCities[$state] = [];
        }

        if (!in_array($city, $statesWithCities[$state])) {
            $statesWithCities[$state][] = $city;
        }
    }
}

// Sort the cities inside each state
foreach ($statesWithCities as $state => $cities) {
    sort($statesWithCities[$state]);
}


// Free result sets
$categoriesResult->free();
$locationResult->free();

$conn->close();

// Return success message
echo json_encode([
    "status" => "success",
    "from" => "jobdiva",
    "message" => "Data retrieved successfully",
    "categories" => $categories,
    "statesWithCities" => $statesWithCities
   
]);
?>
