<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include './config.php';

// Database credentials
$dbname = $database_name;

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

// Retrieve parameters from the request

$selectedStates = isset($_GET['stateValues']) ? json_decode($_GET['stateValues'], true) : [];
$selectedCities = isset($_GET['cityValues']) ? json_decode($_GET['cityValues'], true) : [];
$selectedCategories = isset($_GET['categoryValues']) ? json_decode($_GET['categoryValues'], true) : [];

$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 30;
$offset = ($page - 1) * $limit;


$searchTerm = isset($_GET['searchTerm']) ? $_GET['searchTerm'] : '';


$parts = explode('-', $instance);
$country = $parts[0]; // "usa"
if($country === 'usa'){
   $country = "US";
   
   // Initialize SQL query for jobs
   $sql = "SELECT * FROM $table_name_jobdiva WHERE 1=1 AND jobStatus = 'OPEN' AND country = '$country'";

} elseif($country === 'canada'){
    $country = "CA";
    
   // Initialize SQL query for jobs
   $sql = "SELECT * FROM $table_name_jobdiva WHERE 1=1 AND jobStatus = 'OPEN' AND country = '$country'";
} else {
     $sql = "SELECT * FROM $table_name_jobdiva WHERE 1=1 AND jobStatus = 'OPEN'";
}




$params = [];
$types = '';


// Handle state filtering
if (!empty($selectedStates)) {
    $stateConditions = [];
    foreach ($selectedStates as $state) {
        $stateConditions[] = "postingState LIKE ?";
        $params[] = "%$state%";
        $types .= 's';
    }
    $sql .= " AND (" . implode(' OR ', $stateConditions) . ")";
}

// Handle city filtering
if (!empty($selectedCities)) {
    $cityConditions = [];

    foreach ($selectedCities as $city) {
        $normalizedCity = strtolower(str_replace('-', ' ', urldecode($city)));
        $cityConditions[] = "LOWER(postingCity) LIKE ?";
        $params[] = "%$normalizedCity%";
        $types .= 's';
    }

    $sql .= " AND (" . implode(' OR ', $cityConditions) . ")";
}


if (!empty($selectedCategories)) {
    if (is_array($selectedCategories)) {
        $decodedCategories = array_map('urldecode', $selectedCategories);
    } else {
        $decodedCategories = [urldecode($selectedCategories)];
    }

    // Normalize input: lowercase and remove hyphens
    $normalizedCategories = array_map(function($category) {
        return str_replace('-', ' ', strtolower($category));
    }, $decodedCategories);

    // Create placeholders
    $categoriesPlaceholder = implode(',', array_fill(0, count($normalizedCategories), '?'));

    // Compare against LOWER(jobTitle)
    $sql .= " AND LOWER(jobTitle) IN ($categoriesPlaceholder)";

    foreach ($normalizedCategories as $category) {
        $params[] = $category;
        $types .= 's';
    }
}





/// Handle search term
$searchTerm = trim($searchTerm);
$searchTerm = preg_replace('/\s+/', ' ', $searchTerm);

// Check if the search term is not empty
// Check if the search term is not empty
if (!empty($searchTerm)) {
    // Split the search term by comma to handle multiple distinct search terms
    $searchTerms = explode(',', $searchTerm);

    // Initialize conditions for the SQL query
    $wordConditions = [];

    foreach ($searchTerms as $term) {
        $term = trim($term);
        if (!empty($term)) {
            // Check if the term contains multiple words (we'$sqlre looking for a space in the term)
            if (strpos($term, ' ') !== false) {
                // Treat as a single term
                $searchParam = "%$term%";
                $wordConditions[] = "(jobTitle LIKE ?)";
                $params[] = $searchParam;
                $types .= 's'; // Add string type for prepared statement
            } else {
                // If it's a single word, break it down further into individual words
                $searchWords = preg_split('/[\s, -&]+/', $term);
                foreach ($searchWords as $word) {
                    $word = trim($word);
                    if (!empty($word)) {
                        // Escape special characters and prepare search parameter
                        $word = str_replace(['%', '_'], ['\%', '\_'], $word);
                        $searchParam = "%$word%";
                        $wordConditions[] = "(jobTitle LIKE ?)";
                        $params[] = $searchParam;
                        $types .= 's'; // Add string type for prepared statement
                    }
                }
            }
        }
    }

    // Combine all the word conditions with OR (for multi-word or single word terms)
    if (!empty($wordConditions)) {
        
       if(!empty($selectedCategories)) {
           $sql .= " OR (" . implode(' OR ', $wordConditions) . ")";
       }else {
           $sql .= " AND (" . implode(' OR ', $wordConditions) . ")";
       }
        
    }
}


// --- COUNT QUERY (before adding LIMIT/OFFSET) ---
$countSql = "SELECT COUNT(*) as total FROM $table_name_jobdiva WHERE 1=1";
$countSql .= substr($sql, strlen("SELECT * FROM $table_name_jobdiva WHERE 1=1"));
$countParams = $params;
$countTypes = $types;

// --- Add Pagination ---
$sql .= " LIMIT ? OFFSET ?";
$params[] = $limit;
$params[] = $offset;
$types .= 'ii';

// Prepare and execute the statement for jobs
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die(json_encode(["error" => "Prepare failed: " . $conn->error]));
}

$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$jobs = $result->fetch_all(MYSQLI_ASSOC);   


if (!$result) {
    die(json_encode(["error" => "Query failed: " . $stmt->error]));
}


// --- Prepare and Execute Count Query ---
$countStmt = $conn->prepare($countSql);
if ($countStmt === false) {
    die(json_encode(["error" => "Count prepare failed: " . $conn->error]));
}
if (!empty($countParams)) {
    $countStmt->bind_param($countTypes, ...$countParams);
}
$countStmt->execute();
$countResult = $countStmt->get_result();
$totalRow = $countResult->fetch_assoc();
$totalCount = $totalRow['total'] ?? 0;

$conn->close();

// Return success message
echo json_encode([
    "status" => "success",
    // "count" => count($jobs),
     "totalCount" => $totalCount,
    "currentPage" => $page,
    "limit" => $limit,
    "from" => "jobdiva",
    "message" => "Data retrieved successfully",
    "jobs" => $jobs,
]);

?>
