<!doctype html>
<html lang="en">
<head>
    <title>Job list-Artech</title>
    <?php 
        include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/header.php'); 
        include './config.php'; 
    ?>
</head>
<body class="artech-job">

<script>
    // For the consent box
    document.addEventListener("DOMContentLoaded", function () {
        const closeBtn = document.querySelector(".message-banner-close-btn");
        const banner = document.getElementById("banner_consent");

        // Check if cookie is already set
        const isBannerClosed = document.cookie.split('; ').find(row => row.startsWith('banner_consent='));

        if (isBannerClosed && banner) {
            banner.style.display = "none"; // Hide banner if cookie found
        }

        if (closeBtn && banner) {
            closeBtn.addEventListener("click", function () {
                banner.style.transition = "all 0.5s ease";
                banner.style.transform = "translateY(-20px)";
                banner.style.opacity = "0";

                setTimeout(function () {
                    banner.remove(); // Remove after animation
                }, 500);

                // Set cookie to remember that user closed it
                document.cookie = "banner_consent=1; path=/; max-age=" + 60 * 60 * 24 * 7; // 7 days
            });
        }
    });
</script>

<?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/navbar.php'); ?>
 <div class="full-loader-wrapper">
        <span class="loader"></span>
 </div>

<!-- =====Header Part==== -->
<section class="jobheader py-5">
    <div class="container">
        <div class="text-white my-2">
            <a class="text-white" href="https://artech.com/">HOME</a> > <a class="text-white" href="https://www.artech.com/careers/">CAREERS</a> > <a class="text-white" id="breadcrumb-job-type" href="#"></a> > <a class="text-white" id="breadcrumb-job-country" href="#"></a>
        </div>
        <div class="py-5 pb-2">
            <h1 class="text-white mb-4 " id="main-heading"></h1>
            <p class="text-white" id="banner-description">
                
            </p> 
        </div>
    </div>

</section>

<div class="mb-5">
       <div id="jobdivaheader"><div class="d-none" data-hdr-flag="2"></div>
    
        <script defer="" src="https://artech.sensehq.com/snippet.js"></script> 
        
        <div id="hively-csat-banner-widget">  
        
         <style>
          #hively-csat-banner {border:1px solid #e7e7e7;border-radius:5px;padding:15px;overflow:auto;width:100% !important;font-family:Helvetica,sans-serif;font-weight:300;background-image:url(https://secure.teamhively.com/assets/hex-8e9d28679185f39127b7868f0f4b31ef31cc2116713c9e749ffd69ec22a8fa96.png);background-position:left bottom;background-repeat:repeat-x;background-color:#fff;}
          #hively-csat-banner #cta {float:left;width:50%;text-align:left}
          #hively-csat-banner #cta h2 {font-size:24px;color:#333;margin-top:10px;margin-left:40px;}
          #hively-csat-banner #cta h2 img {height:18px}
          #hively-csat-banner #csat {float:right;width:50%;text-align:right}
          #hively-csat-banner #csat p {font-size:24px;margin:0px 40px 0px 0px;color:#333}
          #hively-csat-banner #csat img#smiley {vertical-align:middle;margin-bottom:5px}
          #hively-csat-banner #csat span#metric {margin-left:15px}
          #hively-csat-banner #attribution {clear:both}
          #hively-csat-banner #attribution p {font-size:12px;margin-top:20px;margin-bottom:0px;text-align:center;color:#666}
          #hively-csat-banner #attribution p a {color:#666}
          #hively-csat-banner #attribution p a img {height:18px}
          #hively-csat-banner #featured_feedback {clear:both}
          #hively-csat-banner #featured_feedback p {font-size:14px;font-style:italic;margin:10px 100px 0px 100px;text-align:center;color:#666}
          #hively-csat-banner #featured_feedback p a {color:#666}
        </style>
             <style>
             @media (max-width:1320px){       
                    /*For hively script*/
            
            #hively-csat-banner-widget #hively-csat-banner{
                    display: flex;
                flex-direction: column;
            }
            #hively-csat-banner-widget #hively-csat-banner #cta{
                width: 100%;
                float: none;
                text-align: center;
                margin: 0px;
                padding: 0px;
            
            }
            
            #hively-csat-banner #cta h2{
                    margin: 0px !important;
                text-align: center;
                font-size: 18px;
            }
            #hively-csat-banner #csat{
                width: 100%;
                float: none;
                text-align: center;
            }
            
            #hively-csat-banner #csat p{
                    margin: 0px !important;
                text-align: center !important;
                    font-size: 20px;
            
            }
            
            #hively-csat-banner #attribution p{
                margin-top:0px;
            }
            
            }
    </style>
        
        
            <div id="hively-csat-banner">
               <div id="cta"><h2>Our Consultants Value Us!</h2></div>
            <div id="csat">
              <p>
                <img id="smiley" src="https://secure.teamhively.com/system/smileys/icons/000/000/004/px_45/Happy.png">
                <span id="metric"><b>96%</b> Satisfaction Rating</span>
              </p>
            </div>
          <div id="attribution">
            <p>
              <a href="https://teamhively.com?utm_source=csat_widget&amp;utm_term=none&amp;utm_content=d1513deb8fec2841" style="color:#666">
              Measured with  <b>Hively</b><img height="18" src="https://secure.teamhively.com/assets/bee-d3a38cd01020d9f2552baa8f1b60915253f16fd45130e295e43f0060684699f7.png"    >
              </a>
            </p>
          </div>
        </div>
        
        </div>
        <script>function csat(data){document.getElementById('hively-csat-banner-widget').innerHTML = data;}</script>
        <script type="text/javascript" src="https://secure.teamhively.com/csat_widget/d1513deb8fec2841/banner?callback=csat"></script>
        
        <!-- Include this code underneath the code for the widget. -->
        <script type="text/javascript">
          document.getElementById("cta").innerHTML = "<h2>Our employees at Artech <img src='https://secure.teamhively.com/assets/heart-b3e4c5b34db40e3f944b4336d39792f63808b67117a50e19708953b55b4d82d6.png' alt='Heart'> us!</h2>";
        </script>
        <!-- Include this code underneath the code for the widget. -->
        <script type="text/javascript">
          document.getElementById("cta").innerHTML = "<h2>Our Consultants Value Us!</h2>";
          document.getElementById("metric").innerHTML = "<b>96%</b> Satisfaction Rating";
        </script>

</div>
</div>

<!-- =======Job List Content======= -->
<div class="container">
    <section class="mb-3 d-none d-lg-block"></section>

    <section class="joblist-container">
        <div class="row">
            <div class="col-md-12 mb-3 bdr-1">
                <form action="" id="job-search-form">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="input-group">
                                <span class="input-group-text" id="basic-addon1">
                                    <img src="<?php echo $site_url; ?>/images/search.svg" alt="">
                                </span>
                                <input id="search-keyword" type="text" class="form-control jl-search" placeholder="Keywords" aria-label="Keywords" aria-describedby="basic-addon1">
                            </div>
                        </div>
                        <div class="col-md-4 m-auto text-end">
                            <button class="btn btn-jl-common">Find Jobs</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-4 px-0">
                <form action="">
                    <select multiple name="" data-group="category" id="categories" class="form-control form-select jl-search"></select>
                </form>
            </div>
            <div class="col-md-4">
                <form action="">
                    <select multiple name="" data-group="state" id="state" class="locations form-control form-select jl-search"></select>
                </form>
            </div>
            <div class="col-md-4 px-0">
                <form action="">
                    <select multiple name="" data-group="city" id="city" class="locations form-control form-select jl-search"></select>
                </form>
            </div>
            <!--<div class="col-md-4">-->
            <!--    <form action="">-->
            <!--        <select multiple name=""  data-group="location" id="location" class="locations form-control form-select jl-search">-->
                        
            <!--        </select>-->
            <!--    </form>-->
            <!--</div>-->
        </div>
    </section>

    <section class="message-banner" id="banner_consent">
        <span class="message-banner-close-btn">&times;</span>
        <div class="message-banner-content">
            <p>
                <span style="color: red;">
                    Please be advised that any emails or communication from the ‘@artechcareers.com’ domain is not connected to Artech LLC or any of its subsidiaries. These messages do not reflect legitimate job opportunities or accurate information regarding positions with our company.
                </span> 
                If you receive any emails (may include, but not limited to job offers or requests for any information or payments) from the ‘@artechcareers.com’ domain, or any domain other than @artech.com, immediately send an email to 
                <a href="email:employmentVerification@artech.com">EmploymentVerification@artech.com</a> to either inform us or verify if the communication is legit or not from Artech.
                To apply with us, visit our website at 
                <a href="www.artech.com/careers/">www.artech.com/careers/</a> for more information.
            </p>
        </div>
    </section>

    <section class="col-md-12" style="display: flex; justify-content: end;">
        <h2 style="text-align: right;line-height:2" id="dynamic_title" class="page-text-heading mx-2 mb-2 fs-14"></h2>
        <span style="line-height:2" class="jobs-count mx-2 mb-2 fs-14"></span>
    </section>

    <section class="mb-5">
        <div class="row d-flex align-items-start">
            <div id="no-job" class="col-md-12 text-center">
                <span>No jobs found!</span>
            </div>
            <div class="col-md-12 text-center">
                <span class="loader"></span>
            </div>
            <div class="col-md-12 px-0">
                <div id="jobs-container" class="nav nav-pills flex-grid" id="v-pills-tab" role="tablist" aria-orientation="vertical"></div>
            </div>
            <div class="col-md-12 px-0 mt-4">
                    <div class="container d-flex space-between stay-updated">
    <div>
        <p style="font-weight: bold; font-size: 24px; margin: 0;">Can’t Find the Right Role?</p>
        <span style="font-size: 16px; color: #555;">Stay updated on opportunities that match your skills and goals.</span>
    </div>
    <div>
        <button class="btn btn-jl-common"  onclick="handleSubmitResume()" style="padding: 10px 20px; font-size: 16px; color: white; border: none; cursor: pointer;">
            Submit your resume
        </button>
    </div>
</div>
            </div>


        </div>
    </section>
    
    
    <section style="display: flex; justify-content: end;">
        <div id="pagination-container"></div>

            <style>
                #pagination-container {
                    display: flex;
                    justify-content: center;
                    flex-wrap: wrap;
                }
                .pagination-btn {
                    padding: 8px 12px;
                    min-width:40px;
                    margin: 4px;
                    border: 1px solid #ccc;
                    color: #333;
                    cursor: pointer;
                    border-radius: 4px;
                    user-select: none;
                    text-align:center;
                }
                .pagination-btn.active {
                    background-color: rgba(37, 62, 145, 1);
                    color: #fff;
                    border-color: rgba(37, 62, 145, 1);
                }
                .pagination-btn.disabled {
                    opacity: 0.5;
                    pointer-events: none;
                }
            </style>

    </section>
</div>

<?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/footer.php'); ?>

<style>
    .job-container {
        cursor: pointer;
    }
    #no-job {
        display: none;
    }
    #search-keyword {
        width: auto;
    }
    #search-keyword:focus {
        background-color: transparent;
    }
</style>

<script>

function renderPagination(totalCount, currentPage, onPageChange) {
    const limit = 30;
    const totalPages = Math.ceil(totalCount / limit);
    const container = document.getElementById('pagination-container');
    container.innerHTML = '';

    if (totalPages <= 1) return;

    container.style.marginBottom = "2rem";
    container.style.marginTop = "1rem";

    const createButton = (label, page, isActive = false, isDisabled = false) => {
        const btn = document.createElement('div');
        btn.className = 'pagination-btn';
        if (isActive) btn.classList.add('active');
        if (isDisabled) btn.classList.add('disabled');
        btn.textContent = label;
        if (!isDisabled && label !== '...') {
            btn.addEventListener('click', () => onPageChange(page));
        }
        return btn;
    };

    const addEllipsis = () => {
        const ellipsis = document.createElement('div');
        ellipsis.className = 'pagination-btn disabled';
        ellipsis.textContent = '...';
        container.appendChild(ellipsis);
    };

    // Prev button
    container.appendChild(createButton('« Prev', currentPage - 1, false, currentPage === 1));

    // Always show first page
    container.appendChild(createButton(1, 1, currentPage === 1));

    // Left ellipsis
    if (currentPage > 3) addEllipsis();

    // Middle pages
    for (let i = currentPage - 1; i <= currentPage + 1; i++) {
        if (i > 1 && i < totalPages) {
            container.appendChild(createButton(i, i, i === currentPage));
        }
    }

    // Right ellipsis
    if (currentPage < totalPages - 2) addEllipsis();

    // Always show last page
    if (totalPages > 1) {
        container.appendChild(createButton(totalPages, totalPages, currentPage === totalPages));
    }

    // Next button
    container.appendChild(createButton('Next »', currentPage + 1, false, currentPage === totalPages));
}


 function handleSubmitResume() {
     const currentPath = window.location.pathname.split('/').slice(0, 2).join('/');
     window.location.href = `${currentPath}/join-our-network`;
 }


 $(document).ready(function () {
  handleGetJobsDataByURL();


  function fetchData(apiUrl, params = []) {
    return $.ajax({
      url: apiUrl,
      type: "GET",
      data: params,
    });
  }

function preserveSpecialCasing(str) {
    const preservedWords = ['QA', 'UI', 'UX', 'II', 'III', 'IV', 'VI', 'VII', 'VIII', 'IX', 'X'];
    
    return str
        .split(' ')
        .map(word => {
            const upperWord = word.toUpperCase();
            return preservedWords.includes(upperWord) ? upperWord : word.toLowerCase();
        })
        .join(' ')
        .replace(/[^\w\s\-]+/g, "")      // Remove special characters
        .replace(/\s+/g, "-");           // Replace spaces with dashes
}


let allStateCityData = {};

function allStateCitiesData(data) {
     const allData = JSON.parse(data);
     allStateCityData  = allData.statesWithCities;
        console.log("Loaded State-City Data:", allStateCityData);
}
function isValidCityStatePair(state, city) {
    if (!state || !city) return false;

    const trimmedState = state.trim().toUpperCase();
    const trimmedCity = city.trim().toLowerCase();

    if (
        allStateCityData.hasOwnProperty(trimmedState) &&
        Array.isArray(allStateCityData[trimmedState])
    ) {
        return allStateCityData[trimmedState]
            .map(c => c.toLowerCase().trim())  // normalize
            .includes(trimmedCity);
    }

    return false;
}



function updateURL(hasJobId) {
    const keyword = $("#search-keyword").val().trim().toLowerCase().replace(/-/g, ' ');
    const states = $("#state").val() || [];
    const categories = $("#categories").val() || [];
    const cities = $("#city").val() || [];

    const firstPathSegment = window.location.pathname
        .split("/")
        .filter(part => part !== "")[0];

    let baseUrl = `${window.location.origin}/${firstPathSegment}/`;

    const allStates = [...new Set(states.map(s => s.trim()))];
    const allCities = [...new Set(cities.map(c => c.trim()))];

    let validLocationSlug = "";
    let slugCity = "";
    let slugState = "";

    // Find the first valid city–state pair to use in the slug
    outerLoop:
    for (const city of allCities) {
        for (const state of allStates) {
            if (isValidCityStatePair(state, city)) {
                slugCity = city;
                slugState = state;
                validLocationSlug = `${slugCity.toLowerCase().replace(/\s+/g, "-")}-${slugState.toUpperCase().replace(/\s+/g, "-")}`;
                break outerLoop;
            }
        }
    }
    
    if (!validLocationSlug && allStates.length === 1 && allCities.length === 0) {
    slugState = allStates[0];
    validLocationSlug = slugState.toUpperCase().replace(/\s+/g, "-");
}

    // Determine the main category or keyword for the path
    let pathCategory = "";
    if (categories.length > 0) {
        
        pathCategory = encodeURIComponent(preserveSpecialCasing(categories[0])).replace(/\s+/g, "-").replace(/--+/g, "-");
    } else if (keyword) {
        pathCategory = encodeURIComponent(preserveSpecialCasing(keyword));
    }

    // Construct the readable path
    if (pathCategory && validLocationSlug) {
        baseUrl += `${pathCategory}-jobs-in-${validLocationSlug}`;
    } else if (pathCategory) {
        baseUrl += `${pathCategory}-jobs`;
    } else if (validLocationSlug) {
        baseUrl += `jobs-in-${validLocationSlug}`;
    }

    // Prepare query parameters
    const params = new URLSearchParams();

    if (hasJobId && typeof jobId !== "undefined") {
        params.append("job_id", jobId);
    }

    if (keyword) {
        params.append("keyword", keyword);
    }

    if (categories.length > 0) {
        params.append("category", categories.map(c => c.toLowerCase().replace(/\s+/g, "-").replace(/--+/g, "-")).join(","));
    }

    if (cities.length > 0) {
        params.append("city", cities.map(c => c.toLowerCase().replace(/\s+/g, "-")).join(","));
    }

    if (states.length > 0) {
        params.append("state", states.map(s => s.toUpperCase().replace(/\s+/g, "-")).join(","));
    }

    // Final URL update
    const finalURL = baseUrl + (params.toString() ? "?" + params.toString() : "");
    window.history.replaceState({}, "", finalURL);

    // console.log("Updated URL:", finalURL);
    
     handleGetJobsDataByURL();
    updateThePageJobsHeading();
}






function handleGetJobsDataByURL(page = 1, limit = 30) {
    $(".loader").addClass("active");
    const url = window.location.href;
    console.log("Full URL:", url);

    const pathSegments = window.location.pathname.split("/").filter(part => part !== "");
    const firstPathSegment = pathSegments[0];

    if (!firstPathSegment) {
        console.error("Invalid URL structure.");
        handlePageWithoutJobsPath();
        return;
    }

    const urlParams = new URLSearchParams(window.location.search);

    // Get query parameters
    let keyword = urlParams.get("keyword") || "";
    let stateParams = urlParams.get("state") ? urlParams.get("state").split(",") : [];
    let cityParams = urlParams.get("city") ? urlParams.get("city").split(",") : [];
    let countryParams = urlParams.get("country") ? urlParams.get("country").split(",") : [];
    let categoryParams = urlParams.get("category") ? urlParams.get("category").split(",") : [];
    let degreeParams = urlParams.get("degree") ? urlParams.get("degree").split(",") : [];

    // Try to extract job title and location from the last path segment if needed
    const lastSegment = pathSegments[pathSegments.length - 1];
    const pathPatternMatch = lastSegment.match(/^(.+)-jobs-in-(.+)$/);

    if (!keyword && pathPatternMatch) {
        keyword = pathPatternMatch[1].replace(/-/g, " ");
    }

    if (cityParams.length === 0 && stateParams.length === 0 && countryParams.length === 0 && pathPatternMatch) {
        const locationFromPath = pathPatternMatch[2]; // e.g., mumbai-maharashtra-india
        const locationParts = locationFromPath.split("-");

        if (locationParts.length === 3) {
            cityParams = [locationParts[0]];
            stateParams = [locationParts[1]];
            countryParams = [locationParts[2]];
        } else if (locationParts.length === 2) {
            stateParams = [locationParts[0]];
            countryParams = [locationParts[1]];
        } else if (locationParts.length === 1) {
            countryParams = [locationParts[0]];
        }
    }

    // Remove duplicate values
    const unique = arr => [...new Set(arr.filter(Boolean))];

    categoryParams = unique(categoryParams);
    cityParams = unique(cityParams);
    stateParams = unique(stateParams);
    countryParams = unique(countryParams);
    degreeParams = unique(degreeParams);

    // Avoid sending searchTerm if it's part of category
    let sendSearchTerm = !categoryParams.includes(keyword.toLowerCase().replace(/\s+/g, "-"));

    // Build location array (used for backend search)
    const locationArray = [...cityParams, ...stateParams, ...countryParams];

    const dataToSend = {
        locationValues: JSON.stringify(locationArray),
        categoryValues: JSON.stringify(categoryParams),
        stateValues: JSON.stringify(stateParams),
        cityValues: JSON.stringify(cityParams),
        countryValues: JSON.stringify(countryParams),
        degreeValues: JSON.stringify(degreeParams),
         page: page,
        limit: limit
    };

    if (sendSearchTerm && keyword) {
        dataToSend.searchTerm = keyword;
    }

    console.log("Sending to API:", dataToSend);

    fetchData("/" + firstPathSegment + "/jobdiva_api.php", dataToSend)
        .done(handleApiResponse)
        .fail(handleError);
}



  function handleApiResponse(data) {
    const parsedData = JSON.parse(data);
  
    console.log(parsedData);
     allJobs = parsedData.jobs;
     
     
     
    
    const jobs = allJobs.filter(job=> job.jobStatus === "OPEN");

    if (jobs.length < 1) {
      $("#no-job").css("display", "block");
      $(".list-scroll").css("display", "none");
       $(".jobs-count").text(``);
       $("#dynamic_title").text(``);
    } else {
      $("#no-job").css("display", "none");
      $(".list-scroll").css("display", "block");
    }

    renderJobElements(jobs);

     const totalCount = parsedData.totalCount;
     const currentPage = parsedData.currentPage;
    
     if (jobs.length === 0 && !sessionStorage.getItem(getSessionKey('noAvailableJobs'))) {
         showSubscribeJobModal('noAvailableJobs')
     } else {
          $(".jobs-count").text(`Showing ${jobs.length} of ${totalCount} Jobs`);
     }
     
    renderPagination(totalCount, currentPage, onPageChange)
    
    $(".loader").removeClass("active");
  }
  
  
function onPageChange(newPage) {
  $(".loader").addClass("active");

  fetchData("<?php echo $current_directory; ?>/jobdiva_api.php", {
    page: newPage,
    limit: 30
  })
  .done(handleApiResponse)
  .fail(handleError);
}

function handleFilterResponse(data) {
  const parsedData = JSON.parse(data);

  const categories = parsedData.categories.sort((a, b) => a.localeCompare(b));
  const statesWithCities = parsedData.statesWithCities;

  const states = Object.keys(statesWithCities).sort((a, b) => a.localeCompare(b));
  
  renderDropdownOptions("#categories", categories);
  renderDropdownOptions("#state", states); // Assuming #location is the state dropdown

  // When a state is selected, populate the cities dropdown
 $('#state').on('change', function () {
    const selectedStates = $(this).val(); // Array of selected states
    const allCities = [];

    if (selectedStates && selectedStates.length > 0) {
        selectedStates.forEach(state => {
            const cities = statesWithCities[state] || [];
            allCities.push(...cities);
        });

        // Remove duplicates and sort alphabetically
        const uniqueCities = [...new Set(allCities)].sort((a, b) => a.localeCompare(b));

        // Get current selected cities and preserve valid ones
        const selectedCities = $('#city').val() || [];
        const stillValidSelectedCities = selectedCities.filter(city => uniqueCities.includes(city));

        // Update city dropdown
        renderDropdownOptions("#city", uniqueCities);

        // Re-select still valid cities
        $('#city').val(stillValidSelectedCities).trigger('change');
    } else {
        // Clear city dropdown if no state selected
        renderDropdownOptions("#city", []);
    }
 });
 
  $(".loader").removeClass("active");
}

  function handleError(xhr, status, error) {
    console.log(error);
  }

  var locationParams = [];
  var categoryParams = [];
  var degreeParams = [];

  $("#job-search-form").on("submit", function (e) {
    e.preventDefault();

    const searchTerm = $("#search-keyword").val();
    const location = $("#location-search").val();

    updateURL(false);
  });

  function handlePageWithoutJobsPath() {
    // Fetch data based on extracted search term and location
    fetchData("<?php echo $current_directory; ?>/jobdiva_api.php")
      .done(handleApiResponse)
      .fail(handleError);
  }

  fetchData("<?php echo $current_directory; ?>/jobdiva_api_filters_data.php")
    .done(handleFilterResponse)
    .fail(handleError);
    
 fetchData("<?php echo $current_directory; ?>/jobdiva_api_filters_data.php")
    .done(allStateCitiesData)
    .fail(handleError);



  function renderJobElements(jobs) {
    const container = $("#jobs-container");
    container.hide();
    container.empty();

    jobs.forEach((job, index) => {
      const jobElement = createJobElement(job, index);

      // Append to container
      container.append(jobElement);
    });

    container.slideDown(500);
    attachScrollListenerAfterJobsLoad()

    
  }

  function createJobElement(job, index) {
    let skillsHtml = "No description available";
    if (job.skills) {
      let skills = $("<div>").html(job.skills).text(); // Decode HTML
      skills = skills.replace(/[()]/g, "").split(" AND "); // Remove parentheses and split by AND.replace('OR',"/")
      skills = skills.map((skill) =>
        skill
          .split(" ")
          .map((word) => (word === "OR" ? "/" : word))
          .join(" ")
      );

      let visibleSkills = skills.slice(0, 3); // Show first 3 skills
      let remainingSkills = skills.length - visibleSkills.length;

      skillsHtml = visibleSkills
        .map(
          (skill) => `
                        <div style="width:fit-content" class=" bdr-2 text-center py-1 px-2 m-1 fs-12">${skill.trim()}</div>
                    `
        )
        .join("");

      if (remainingSkills > 0) {
        skillsHtml += `
                        <div  style="width:80px" class=" bdr-2 text-center py-1 px-2 m-1 fs-12 btn btn-jl-common">+${remainingSkills}</div>
                        `;
      }
    }
    const startDate = new Date(job.startDate);
    const endDate = new Date(job.endDate);
    const durationInMonths =
      (endDate.getFullYear() - startDate.getFullYear()) * 12 +
      (endDate.getMonth() - startDate.getMonth());
      
     const completeLocation = `${job.postingCity ? job.postingCity + ',' : ''} ${job.postingState ? job.postingState  + ',' : ''}  ${job.postingCountry ? job.postingCountry : ''} `;

    return `
  <div class="${index === 0 ? "active" : ""} bdr-1 job-container grid-item" 
       id="v-pills-home-tab" 
       data-job-status="${job.jobStatus}"
       data-bs-toggle="pill" 
       data-job-id="${job.id}" 
       data-job-title="${job.jobTitle}"
       data-bs-target="#v-pills-jobcard-${job.id}" 
       type="button" 
       role="tab" 
       aria-controls="v-pills-home" 
       aria-selected="true">
    
    <div class="py-4 px-2">
      <div class="row">
        <div class="col-6">
          <button class="btn ${
            job.address1 === "virtual" ? "btn-remote" : "btn-remote"
          }">
            ${job.address1 === "virtual" ? "Remote" : "On-site"}
          </button>
        </div>

        <div class="col-6 mx-0 p-0 my-auto fs-14 text-end">
          ${job.dateIssued || ""}
        </div>

        <div class="col-12 text-center fw-700 mt-3">
          ${job.jobTitle || ""}
        </div>
         <div class="col-12 col-12 text-center fw-400 my-1 mb-3 fs-14 d-flex justify-content-center align-items-center">
           <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
                <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10" />
                <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6" />
            </svg>&nbsp; ${completeLocation ? completeLocation.charAt(0).toUpperCase() + completeLocation.slice(1) : ""}
        </div>

        <div class="col-12 m-0">
          <div class="row justify-content-center align-items-center flex-wrap">
            ${skillsHtml}
          </div>
        </div>

        <div class="col-12 text-center">
          <p class="mb-0 mt-4 fs-12">Duration: ${durationInMonths} Months</p>
        </div>
      </div>
    </div>
    
  </div>
`;
  }

function renderDropdownOptions(selector, optionsArray) {
    const $dropdown = $(selector);
    $dropdown.empty(); // Clear existing options

    optionsArray.forEach(option => {
        $dropdown.append($('<option>', {
            value: option,
            text: option
        }));
    });

    $dropdown.trigger("change"); // Notify any listeners
}

  $(document).on("click", ".share-job", function (e) {
    e.preventDefault();

    const jobId = $(this).data("job-id");

    const shareUrl =
      "<?php echo $current_directory; ?>/jobdetail_oracle.php?job_id=" + jobId;
    // Copy the URL to the clipboard
    navigator.clipboard
      .writeText(shareUrl)
      .then(() => {
        Swal.fire({
          title: "Success!",
          text: "Link copied to clipboard",
          icon: "success",
          confirmButtonText: "Cool",
        });
      })
      .catch((err) => {
        console.error("Failed to copy: ", err);
      });
  });

  $(document).on("click", ".job-container", function (e) {
    e.preventDefault();

    const jobId = $(this).data("job-id");
    const jobTitle = $(this)
      .data("job-title")
      .toLowerCase()
      .replace(/\s+/g, "-") // Replace spaces with dashes
      .replace(/[\/]+/g, "") // Remove all slashes "/"
      .replace(/-+/g, "-")
      .replace(/\.+/g, ""); // Replace multiple dashes with a single dash

    const newUrl =
      "<?php echo $current_directory; ?>/" + jobTitle + "-" + jobId;

    // Open in a new tab
    window.open(newUrl, "_blank");
  });

  function checkDeviceWidth() {
    var windowWidth = $(window).width();

    if (windowWidth < 1024) {
      $(document).on("click", ".job-container", function () {
        const jobId = $(this).data("job-id");

        const currentUrl =
          "<?php echo $current_directory; ?>/jobdetail_jobdiva.php?job_id=" +
          jobId; // Get the current URL

        window.location.href = currentUrl;
      });
    }
  }

  // Initial check on page load
  checkDeviceWidth();

  // Event listener for window resize
  $(window).resize(function () {
    checkDeviceWidth();
  });
});

</script>
