<!doctype html>
<html lang="en">

<head>
    <title>Job Details - Artech</title>
     <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/header.php');
     
      
      ?>
</head>

<body class="artech-job">
    <script>
document.addEventListener("DOMContentLoaded", function() {
  const dropZone = document.getElementById("dropZone");
  const fileInput = document.getElementById("upload_image_logo");
  const uploadGallery = document.getElementById("upload_gallery");

  if (!dropZone || !fileInput || !uploadGallery) return;

  // Prevent defaults
  ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
    dropZone.addEventListener(eventName, preventDefaults, false);
  });

  function preventDefaults(e) {
    e.preventDefault();
    e.stopPropagation();
  }

  // Highlight on drag
  ['dragenter', 'dragover'].forEach(eventName => {
    dropZone.addEventListener(eventName, () => dropZone.classList.add('highlight'), false);
  });

  ['dragleave', 'drop'].forEach(eventName => {
    dropZone.addEventListener(eventName, () => dropZone.classList.remove('highlight'), false);
  });

  // Handle file drop
  dropZone.addEventListener('drop', function(e) {
    const dt = e.dataTransfer;
    const files = dt.files;
    if (files.length) {
      fileInput.files = files;
      showUploadedFiles(files);
    }
  });

  // Handle normal file selection
  fileInput.addEventListener('change', function(e) {
    if (fileInput.files.length) {
      showUploadedFiles(fileInput.files);
    }
  });

  // Show uploaded file names
  function showUploadedFiles(files) {
    uploadGallery.innerHTML = ''; // Clear previous files
    Array.from(files).forEach(file => {
      const fileBox = document.createElement('div');
      fileBox.className = 'uploaded-file-box p-2 border rounded small';
      fileBox.innerText = file.name;
      uploadGallery.appendChild(fileBox);
    });
  }
  
  
  
      document.getElementById('dropZone').addEventListener('click', function(e) {
    // Only trigger if clicking on the container or non-input elements
  
    if (!e.target.closest('input[type="file"]')) {
      document.getElementById('upload_image_logo').click();
    }
  });
});
</script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/navbar.php'); ?>
    <div class="full-loader-wrapper">
        <span class="loader"></span>
    </div>


    <!-- =======Job List Content======= -->
    <div class="container">
        <section class="m-3">
            <div class="row">
                <div class="col-md-12">
                         <div class="card mt-4 p-2">
                                <div class="card-body py-4">
                                    <div class="col-md-12 mb-4">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <h1 class="text-theme-primary">Get Alerts for Suitable Roles</h1>
                                                <!--<h2 class="fs-20 fw-500"></h2>-->
                                                <p>Want to hear about the latest openings that fit your profile? Share a few quick details and upload your resume so we can send you the most relevant opportunities.</p>
                                                <span  class="text-grey">All fields marked with an asterisk (*) are required.</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <form action="" id="job_apply_form"  enctype="multipart/form-data">
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <input type="text" for="firstName" name="firstName" class="form-control fs-16"
                                                        placeholder="First Name*" required >
                                                </div>
                                                <div class="col-md-6  mb-3">
                                                    <input type="text" class="form-control fs-16"
                                                        placeholder="Last Name*"  name="lastName" required>
                                                </div>
                                                <div class="col-md-6  mb-3">
                                                    <input type="email"  id="email" class="form-control fs-16"
                                                        placeholder="Primary Email*"  name="email" required>
                                                </div>
                                                 <div class="col-md-6  mb-3">
                                                    <input type="verify-email" id="verify-email" class="form-control fs-16"
                                                        placeholder="Confirm Email*"  name="verify-email" required>
                                                </div>
                                                <div class="col-12 mb-3">
                                                    <span id="email-error" class="email-error" style="color: red; font-size: 14px;"></span>
                                                </div>
                                            
                                                <div class="col-md-6  mb-3">
                                                    <input type="number" class="form-control fs-16"
                                                        placeholder="Phone No"  name="phone">
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                  <select class="form-control fs-16" name="country" id="country" required>
                                                    <option value="">Select Country*</option>
                                                    <option value="US">United States</option>
                                                    <option value="Canada">Canada</option>
                                                    <option value="India">India</option>
                                                    <option value="Philippines">Philippines</option>
                                                  </select>
                                                </div>
                                                
                                         

                                                <div class="col-md-6 mb-3">
                                                  <select class="form-control fs-16" name="state" id="stateSelect">
                                                    <option value="">Select State</option>
                                                  </select>
                                                </div>
                                                
                                           
                                                <div class="col-md-6  mb-3">
                                                    <input type="text" class="form-control fs-16"
                                                        placeholder="City"  name="city">
                                                </div>
                                                 <div class="col-md-6  mb-3">
                                                    <input type="number" class="form-control fs-16"
                                                        placeholder="Zip Code"  name="zip">
                                                </div>
                                                <!--<div class="col-md-12  mb-3">-->
                                                <!--    <input type="text" class="form-control fs-16"-->
                                                <!--        placeholder="Additional Info*"  name="info" required>-->
                                                <!--</div>-->
                                                
                                                <div class="col-md-6 mb-3">
                                                  <select id="domain" name="domain" class="form-control" required>
                                                    <option value="">Select Domain*</option>
                                                        <option value="Administration">Administration</option>
                                                        <option value="Finance">Finance</option>
                                                        <option value="Human Resources">Human Resources</option>
                                                        <option value="Marketing">Marketing</option>
                                                        <option value="Recruiting">Recruiting</option>
                                                        <option value="Others">Others</option>
                                                  </select>
                                                </div>

                                                <div class="col-md-12">
                                                    <fieldset class="upload_dropZone text-center mb-3 p-4" id="dropZone">
                                                        <legend class="visually-hidden">Upload Your Resume</legend>
                                                         
                                                        <div class="upload-content">
                                                          <img src="/images/upload.svg" alt="Upload Icon" class="mb-3" />
                                                         
                                                          <p class="small mb-2 text-grey">
                                                            Help us recommend the most relevant roles.<br>
                                                            We accept <strong>.DOC, .DOCX</strong>, and <strong>PDF</strong> files up to 1MB. <br>
                                                            <em>Scanned or image files are not supported.</em>
                                                          </p>
                                                         
                                                          <input 
                                                            type="file" 
                                                            id="upload_image_logo" 
                                                            name="file" 
                                                            class="position-absolute invisible" 
                                                            data-post-name="image_logo"
                                                            data-post-url="https://someplace.com/image/uploads/logos/"
                                                            accept="image/jpeg, image/png, image/svg+xml, application/pdf" 
                                                            multiple 
                                                          />
                                                         
                                                          <label for="upload_image_logo" class="browse-label">
                                                            <i class="text-grey">or</i> 
                                                            <span class="text-voilet">browse your device</span>
                                                          </label>
                                                          <div id="upload_gallery" class="upload_gallery d-flex flex-wrap justify-content-center gap-3 mb-0 mt-3"></div>
                                                        </div>
                                                     </fieldset>

                                                      <div style="font-size:12.5px" id="file-upload-ack" class="mt-3 mb-2 text-success"></div>
                                                </div>
                                      
                                                <div class="col-md-12 mb-3 px-4">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="consentCheckbox" checked>
                                                        <label style="text-align:justify; font-size: 13px !important;" class="form-check-label" for="consentCheckbox">
                                                            By checking this box, you agree to receive calls, AI-generated calls, text messages, or emails from Artech and its affiliates, and contracted partners. Frequency varies for text messages. Message and data rates may apply. Carriers are not liable for delayed or undelivered messages. You can reply STOP to cancel and HELP for help. You can access our privacy policy at 
                                                            <a style=" font-size: 13px !important; color: rgba(37, 62, 145, 1)"  href="https://www.artech.com/privacy-policy/" target="_blank">https://www.artech.com/privacy-policy/</a>.
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 text-center">
                                                    <button type="submit" id ="jobApplybtn" class="btn btn-jl-common">Subscribe and Submit</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                </div>
            </div>
        </section>
    </div>
    <!-- ========================= -->

    <?php include_once('includesnew/footer.php') ?>

</body>

</html>

<script>


    $(document).ready(function () {
        const pathArray = window.location.pathname.split('/');
        const lastPart = pathArray.filter(part => part !== "").pop(); // Get the last non-empty segment
         $(".full-loader-wrapper").addClass('d-none');

        
        
      

     
         $('#job_apply_form').on('submit', function(e) {
             e.preventDefault();
           
             
             const consent_value = $('#consentCheckbox').is(':checked') ? 1 : 0;
             // Initialize FormData to handle the form and file
 
             const formData = new FormData(this); // Create a FormData object
             
             const jobId = 0; // Get job ID
             formData.append('jobId', jobId); // Add the jobId to the FormData object
             
              formData.append('communication_consent', consent_value); 
              const url = window.location.pathname;
             // Get the first segment dynamically
             const firstPathSegment = url.split("/").filter((part) => part !== "")[0];
         
             if (!firstPathSegment) {
               console.error("Invalid URL structure.");
               handlePageWithoutJobsPath();
               return;
             }
   
               
             // Make AJAX request
             $.ajax({
                 url: "/" + firstPathSegment + "/oracle_subscribe_job.php", // Backend URL
                 type: "POST",
                 data: formData, // Use FormData object
                 dataType: 'json',
                 contentType: false, // Let jQuery set the content type to multipart/form-data
                 processData: false, // Prevent jQuery from converting FormData into a query string
                 success: function(response) {
                      $(".full-loader-wrapper").addClass('d-none');
                     if(response.success){
                         
                           Swal.fire({
                       
                        text: `${response.message}`,
                        icon: 'success',
                        confirmButtonText: 'Okay',
                        customClass: {
                          htmlContainer: 'bold-text'
                         }
         
                     }).then(() => {
                         // After the user clicks "Cool" on the success alert:
                         setHasAppliedLocalStorage()
                         // 1. Reset the form
                         $('#job_apply_form')[0].reset();
                         
                         // 2. Redirect to the job list page
                         window.location.href = window.location.origin + "/" + firstPathSegment;
         
                         
                     });
                         
                     }else {
                         
                        Swal.fire({
                           title: 'Error!',
                           text: `${response.message}`,
                           icon: 'error',
                           confirmButtonText: 'Okay'
                        });
                     }
                   
                     
                 },
                 error: function(xhr, status, error) {
                     Swal.fire({
                        title: 'Error!',
                        text: 'Something went wrong. Please try again.',
                        icon: 'error',
                        confirmButtonText: 'Okay'
                     });
                 }
             });
         });
    });
    
    
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('#job_apply_form');
    const email = document.getElementById('email');
    const verifyEmail = document.getElementById('verify-email');
    const emailError = document.getElementById('email-error');

    function validateEmails() {
        const emailVal = email.value.trim();
        const verifyVal = verifyEmail.value.trim();

        emailError.textContent = "";
        verifyEmail.classList.remove('is-invalid');

        if (verifyVal === "") {
            // Nothing typed yet
            return;
        }

        // Check character-by-character match
        if (!emailVal.startsWith(verifyVal)) {
            emailError.textContent = "Email and Verify Email do not match.";
            verifyEmail.classList.add('is-invalid');
        }
    }

    email.addEventListener('input', validateEmails);
    verifyEmail.addEventListener('input', validateEmails);

    form.addEventListener('submit', function(e) {
        const emailVal = email.value.trim();
        const verifyVal = verifyEmail.value.trim();
        
        if (emailVal !== verifyVal) {
            e.preventDefault();
            emailError.textContent = "Email and Verify Email do not match.";
            verifyEmail.classList.add('is-invalid');
            verifyEmail.focus();
        }
    });
});


  const stateOptions = {
    US: [
      "Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware",
      "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky",
      "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi",
      "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico",
      "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon", "Pennsylvania",
      "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont",
      "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming"
    ],
    Canada: [
      "Alberta", "British Columbia", "Manitoba", "New Brunswick", "Newfoundland and Labrador",
      "Nova Scotia", "Ontario", "Prince Edward Island", "Quebec", "Saskatchewan", "Northwest Territories",
      "Nunavut", "Yukon"
    ],
    India: [
      "Andhra Pradesh", "Arunachal Pradesh", "Assam", "Bihar", "Chhattisgarh", "Goa", "Gujarat",
      "Haryana", "Himachal Pradesh", "Jharkhand", "Karnataka", "Kerala", "Madhya Pradesh",
      "Maharashtra", "Manipur", "Meghalaya", "Mizoram", "Nagaland", "Odisha", "Punjab", "Rajasthan",
      "Sikkim", "Tamil Nadu", "Telangana", "Tripura", "Uttar Pradesh", "Uttarakhand", "West Bengal",
      "Andaman and Nicobar Islands", "Chandigarh", "Dadra and Nagar Haveli and Daman and Diu",
      "Delhi", "Jammu and Kashmir", "Ladakh", "Lakshadweep", "Puducherry"
    ],
    Philippines: [
      "Abra", "Agusan del Norte", "Agusan del Sur", "Aklan", "Albay", "Antique", "Apayao", "Aurora",
      "Basilan", "Bataan", "Batanes", "Batangas", "Benguet", "Biliran", "Bohol", "Bukidnon", "Bulacan",
      "Cagayan", "Camarines Norte", "Camarines Sur", "Camiguin", "Capiz", "Catanduanes", "Cavite",
      "Cebu", "Cotabato", "Davao de Oro", "Davao del Norte", "Davao del Sur", "Davao Occidental",
      "Davao Oriental", "Dinagat Islands", "Eastern Samar", "Guimaras", "Ifugao", "Ilocos Norte",
      "Ilocos Sur", "Iloilo", "Isabela", "Kalinga", "La Union", "Laguna", "Lanao del Norte",
      "Lanao del Sur", "Leyte", "Maguindanao del Norte", "Maguindanao del Sur", "Marinduque",
      "Masbate", "Metro Manila", "Misamis Occidental", "Misamis Oriental", "Mountain Province",
      "Negros Occidental", "Negros Oriental", "Northern Samar", "Nueva Ecija", "Nueva Vizcaya",
      "Occidental Mindoro", "Oriental Mindoro", "Palawan", "Pampanga", "Pangasinan", "Quezon",
      "Quirino", "Rizal", "Romblon", "Samar", "Sarangani", "Siquijor", "Sorsogon", "South Cotabato",
      "Southern Leyte", "Sultan Kudarat", "Sulu", "Surigao del Norte", "Surigao del Sur", "Tarlac",
      "Tawi-Tawi", "Zambales", "Zamboanga del Norte", "Zamboanga del Sur", "Zamboanga Sibugay"
    ]
  };

  const countrySelect = document.getElementById("country");
  const stateSelect = document.getElementById("stateSelect");

  countrySelect.addEventListener("change", function () {
    const selectedCountry = this.value;
    const states = stateOptions[selectedCountry] || [];

    // Reset state dropdown
    stateSelect.innerHTML = '<option value="">Select State*</option>';

    // Populate states
    states.forEach(state => {
      const option = document.createElement("option");
      option.value = state;
      option.textContent = state;
      stateSelect.appendChild(option);
    });
  });

    
$(document).on('click', '.redirect-down', function(e) {
    e.preventDefault();
    $('html, body').animate({
        scrollTop: $("#jobApplybtn").offset().top
    }, 1000);
});
</script>
