<?php 
ini_set("display_errors",1);
error_reporting(E_ALL);


include './config.php';
include './sendEmail.php';

  $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
  $root_url = $protocol . "://" . $_SERVER['HTTP_HOST']; 
  $current_directory = $root_url . dirname($_SERVER['PHP_SELF']);


// Get POST data
$firstName = isset($_POST['firstName']) ? $_POST['firstName'] : '';
$lastName = isset($_POST['lastName']) ? $_POST['lastName'] : '';
$phone = isset($_POST['phone']) ? $_POST['phone'] : '';
$email = isset($_POST['email']) ? $_POST['email'] : '';
$jobId = isset($_POST['jobId']) ? $_POST['jobId'] : '';
$info = isset($_POST['info']) ? $_POST['info'] : '';
$state = isset($_POST['state']) ? $_POST['state'] : '';
$city = isset($_POST['city']) ? $_POST['city'] : '';
$zip = isset($_POST['zip']) ? $_POST['zip'] : '';
$domain = isset($_POST['domain']) ? $_POST['domain'] : '';
$country = isset($_POST['country']) ? $_POST['country'] : '';
$communication_consent = isset($_POST['communication_consent']) ? $_POST['communication_consent'] : '';


// as all the enteries are going to same table thus below changes are to differentiate the source of appication
if($jobId == 0){
   $jobId = NULL; 
}
$is_subscribed = 1;



// Check if all fields are filled
if (empty($firstName) || empty($lastName) || empty($email)) {
    echo json_encode(array("success" => false, "message" => "Please fill in all required fields."));
    exit();
}

// Validate email
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(array("success" => false, "message" => "Invalid email address."));
    exit();
}

// Handle file upload
$file = isset($_FILES['file']) ? $_FILES['file'] : null;
$fileName = '';
$base64Resume = ''; 

if ($file && $file['error'] === UPLOAD_ERR_OK) {
    $fileTmpName = $file['tmp_name'];
     $fileExtension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $fileName = strtolower($firstName . '_' . $lastName . '_resume.' . $fileExtension);
    $fileType = mime_content_type($fileTmpName); // Get the MIME type of the file
    $fileSize = $file['size']; // File size in bytes
    $uploadDir = './filesnew/';
    $targetPath = $uploadDir . $fileName;
    
      $fullFileName ="https://jobs.artechdev.net".dirname($_SERVER['PHP_SELF']). "/resume/".    $fileName;

    // Validate file type
    $allowedTypes = array('image/jpeg', 'image/png', 'image/svg+xml', 'application/pdf');
    if (!in_array($fileType, $allowedTypes)) {
        echo json_encode(array("success" => false, "message" => "Invalid file type. Allowed types: JPG, PNG, SVG, PDF."));
        exit();
    }

    // Validate file size (e.g., limit to 5MB)
    $maxFileSize = 5 * 1024 * 1024; // 5MB in bytes
    if ($fileSize > $maxFileSize) {
        echo json_encode(array("success" => false, "message" => "File size exceeds the maximum limit of 5MB."));
        exit();
    }

    // Ensure the upload directory exists
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

 // After moving the uploaded file to the target directory
if (move_uploaded_file($fileTmpName, $targetPath)) {
    // Read the file and encode it to base64
    $base64Resume = base64_encode(file_get_contents($targetPath)); // Use $targetPath instead of $fileTmpName
} else {
    echo json_encode(array("success" => false, "message" => "Failed to upload file."));
    exit();
}
} else {
    // No file was uploaded or there was an error with the file upload
    if (isset($file) && $file['error'] !== UPLOAD_ERR_NO_FILE) {
        echo json_encode(array("success" => false, "message" => "File upload error: " . $file['error']));
        exit();
    } else {
        // If no file was uploaded and no error occurred
        echo json_encode(array("success" => false, "message" => "No file uploaded. Please upload a file."));
        exit();
    }
    
}

// Create database connection
$conn = new mysqli($servername, $username, $password, $database_name);

if ($conn->connect_error) {
    die(json_encode(array("success" => false, "message" => "Connection failed: " . $conn->connect_error)));
}

// Prepare SQL statement
$sql = "INSERT INTO $oracle_job_applications_table (jobId, firstName, lastName, phone, email, info, state,city,zip,domain,country, file, base64Resume, communication_consent ,is_subscribed) VALUES (?,? , ? , ? , ?, ?,?, ? , ?, ?, ?, ?, ?, ?,?)";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("sssssssssssssss", $jobId, $firstName, $lastName, $phone, $email, $info,$state,$city,$zip,$domain,$country, $fullFileName, $base64Resume, $communication_consent,$is_subscribed);
    if ($stmt->execute()) {
        // $newId = $conn->insert_id;
        
        // if($jobId !== NULL){
        //       $sentTooracle =  sendDataTooracle($newId);
        //       if($sentTooracle){
        //             echo json_encode(array("success" => true, "message" => "Application submitted successfully."));
        //              // sendJobApplicationEmail($cleanedDir, $email, $jobId, $firstName, $lastName, $phone, $state, $city, $zip, $domain,$fullFileName);
        //       } else {
        //           echo json_encode(array("success" => false, "message" => "Error in Submiting application."));
        //       }
        // } else {
        //      echo json_encode(array("success" => true, "message" => "Application submitted successfully."));
        // }


        echo json_encode(array("success" => true, "message" => "Application submitted successfully."));
           
        
        
        
    } else {
        echo json_encode(array("success" => false, "message" => "Error: " . $stmt->error));
    }
    $stmt->close();
} else {
    echo json_encode(array("success" => false, "message" => "Failed to prepare the SQL statement."));
}

$conn->close();
?>
