<?php
   ini_set("display_errors",1);
   error_reporting(E_ALL);
include './config.php';
include_once($_SERVER['DOCUMENT_ROOT'] . '/send-mail/sendEmailCronError.php');
set_time_limit(300);
$start_time = microtime(true);

// below code is used for giving the manual url for running cron
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$root_url = $protocol . "://" . $_SERVER['HTTP_HOST']; 
$current_directory = $root_url . dirname($_SERVER['PHP_SELF']);
$manual_cron_url = $current_directory.'/oracle_fetch_jobs_cron.php';


$limit = 400;
$offset = 0; 
$total_actual_fetched = 0;
$hasMoreRecords = true;

$all_jobs = [];
$total_jobs_to_fetch = checkTotalJobsInPortal();



do {
     $oracle_api_url_paginated = $oracle_api_url . ',limit=' . $limit . ',offset=' . $offset;

    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $oracle_api_url_paginated);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    
    // Execute cURL session
    $api_response = curl_exec($ch);
    if (curl_errno($ch)) {
        die(json_encode(["error" => "cURL error: " . curl_error($ch)]));
    }
    
    curl_close($ch); // Close the cURL session
    
     
    $decoded_response = json_decode($api_response, true);
    if (!isset($decoded_response['items'][0]['requisitionList'])) {
        $hasMoreRecords = false;
        break;
    }
    
    $api_response_jobs_data = $decoded_response['items'][0]['requisitionList'];
    $total_jobs_in_api = $decoded_response['items'][0]['TotalJobsCount'];
     
    $currentBatchCount = count($api_response_jobs_data);
    $total_actual_fetched += count($api_response_jobs_data);
    $offset += $limit;

    // If we got no records, break the loop
    if ($currentBatchCount < $limit) {
        $hasMoreRecords = false;
    }
    
    // Check for API response errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        $error_message = "JSON decode error: " . json_last_error_msg();
        sendErrorMailForCron('Job Fetch',$instance, $manual_cron_url, $error_message);
        die(json_encode(["error" => $error_message]));
    }
    
    
     // Append jobs to the main list
     $all_jobs = array_merge($all_jobs, $api_response_jobs_data);

    
    
    
    // Connect to the database
    $conn = new mysqli($servername, $username, $password, $database_name);
     if ($conn->connect_error) {
        $error_message = "Database connection failed: " . $conn->connect_error;
        sendErrorMailForCron('DB Connection',$instance, $manual_cron_url, $error_message);
        die(json_encode(["error" => $error_message]));
    }
    
    // Define table name and columns
    $table_name = $table_name_oracle;
    
    
    
    $columns = [
        'id' => 'VARCHAR(255)',
        'title' => 'VARCHAR(255)',
        'postedDate' => 'DATE',
        'postingEndDate' => 'DATETIME',
        'language' => 'VARCHAR(50)',
        'primaryLocationCountry' => 'VARCHAR(50)',
        'geographyId' => 'BIGINT',
        'hotJobFlag' => 'BOOLEAN',
        'workplaceTypeCode' => 'VARCHAR(255)',
        'jobFamily' => 'VARCHAR(255)',
        'jobFunction' => 'VARCHAR(255)',
        'workerType' => 'VARCHAR(255)',
        'contractType' => 'VARCHAR(255)',
        'managerLevel' => 'VARCHAR(255)',
        'jobSchedule' => 'VARCHAR(255)',
        'jobShift' => 'VARCHAR(255)',
        'jobType' => 'VARCHAR(255)',
        'studyLevel' => 'VARCHAR(255)',
        'domesticTravelRequired' => 'VARCHAR(255)',
        'internationalTravelRequired' => 'VARCHAR(255)',
        'workDurationYears' => 'INT',
        'workDurationMonths' => 'INT',
        // 'workHours' => 'VARCHAR(255)',
        // 'workDays' => 'VARCHAR(255)',
        // 'department' => 'VARCHAR(255)',
        // 'organization' => 'VARCHAR(255)',
        // 'mediaThumbUrl' => 'VARCHAR(255)',
        'shortDescriptionStr' => 'TEXT',
        'primaryLocation' => 'VARCHAR(255)',
        'distance' => 'FLOAT',
        'trendingFlag' => 'BOOLEAN',
        'beFirstToApplyFlag' => 'BOOLEAN',
        'relevancy' => 'INT',
        'workplaceType' => 'VARCHAR(255)',
        'externalQualificationsStr' => 'TEXT',
        'externalResponsibilitiesStr' => 'TEXT',
        'secondaryLocations' => 'TEXT',
        // Add extra columns here
        'category' => 'VARCHAR(255)',
        'requisitionType' => 'VARCHAR(255)',
        'jobGrade' => 'VARCHAR(255)',
        'requisitionId' => 'VARCHAR(255)',
        'externalPostedStartDate' => 'DATETIME',
        'jobLevel' => 'VARCHAR(255)',
        'externalContactName' => 'VARCHAR(255)',
        'externalContactEmail' => 'VARCHAR(255)',
        'externalPostedEndDate' => 'DATETIME',
        'jobFamilyId' => 'BIGINT',
        'geographyNodeId' => 'BIGINT',
        'externalDescriptionStr' => 'TEXT',
        'corporateDescriptionStr' => 'TEXT',
        'organizationDescriptionStr' => 'TEXT',
        'contentLocale' => 'VARCHAR(50)',
        'objectVerNumberProfile' => 'VARCHAR(50)',
        'applyWhenNotPostedFlag' => 'BOOLEAN',
        'internalQualificationsStr' => 'TEXT',
        'internalResponsibilitiesStr' => 'TEXT',
        // 'JobFunctionCode' => 'VARCHAR(255)',
        // 'OtherRequisitionTitle' => 'VARCHAR(255)',
        // 'NumberOfOpenings' => 'INT',
        // 'HiringManager' => 'VARCHAR(255)',
        // 'LegalEmployer' => 'VARCHAR(255)',
        // 'BusinessUnit' => 'VARCHAR(255)',
        // 'WorkMonths' => 'INT',
        // 'WorkYears' => 'INT',
        // 'media' => 'VARCHAR(255)',
        // 'workLocation' => 'VARCHAR(255)',
        // 'otherWorkLocations' => 'TEXT',
        'requisitionFlexFields' => 'TEXT',
        // 'primaryLocationCoordinates' => 'VARCHAR(255)',
        'skills' => 'TEXT'
    ];
    
    // Add missing columns if necessary
    $addColumnsResult = addMissingColumns($conn, $table_name, $columns);
    
    if ($addColumnsResult !== true) {
        die(json_encode(["error" => $addColumnsResult]));
    }
    
    // Prepare statement for inserting data
    $columnsList = array_keys($columns);
    $placeholders = rtrim(str_repeat("?, ", count($columns)), ", ");
    $types = str_repeat('s', count($columns)); // Assumes all columns are strings
    
    
    $sql = "INSERT INTO `$table_name` (`" . implode("`, `", $columnsList) . "`) VALUES ($placeholders)";
    $stmt = $conn->prepare($sql);
    
     if (!$stmt) {
        $error_message = "Prepare statement failed: " . $conn->error;
        sendErrorMailForCron('DB Insert',$instance, $manual_cron_url, $error_message);
        die(json_encode(["error" => $error_message]));
    }

    
    $check_sql = "SELECT COUNT(*) FROM `$table_name` WHERE `id` = ?";
$check_stmt = $conn->prepare($check_sql);
if (!$check_stmt) {
    $error_message = "Prepare check statement failed: " . $conn->error;
    sendErrorMailForCron('DB Check', $instance, $manual_cron_url, $error_message);
    die(json_encode(["error" => $error_message]));
}

// Prepare INSERT statement
$insert_columns = array_keys($columns);
$insert_placeholders = rtrim(str_repeat("?, ", count($insert_columns)), ", ");
$insert_sql = "INSERT INTO `$table_name` (`" . implode("`, `", $insert_columns) . "`) VALUES ($insert_placeholders)";
$insert_stmt = $conn->prepare($insert_sql);
if (!$insert_stmt) {
    $error_message = "Prepare insert statement failed: " . $conn->error;
    sendErrorMailForCron('DB Insert Prepare', $instance, $manual_cron_url, $error_message);
    die(json_encode(["error" => $error_message]));
}

// Prepare UPDATE statement
$update_fields = array_map(function($col) { return "`$col` = ?"; }, $insert_columns);
$update_sql = "UPDATE `$table_name` SET " . implode(", ", $update_fields) . " WHERE `id` = ?";
$update_stmt = $conn->prepare($update_sql);
if (!$update_stmt) {
    $error_message = "Prepare update statement failed: " . $conn->error;
    sendErrorMailForCron('DB Update Prepare', $instance, $manual_cron_url, $error_message);
    die(json_encode(["error" => $error_message]));
}

foreach ($api_response_jobs_data as $job) {
    $jobId = $job['Id'];
    
    // Check if the job already exists
    $check_stmt->bind_param('s', $jobId);
    $check_stmt->execute();
    $check_stmt->bind_result($exists);
    $check_stmt->fetch();
    $check_stmt->free_result();
    
    $oracle_single_job_api_url = $oracle_single_job_api_url.'Id='. urlencode($jobId).',siteNumber='. $siteNumber;

    // Initialize cURL session
    $ch_single = curl_init();
    curl_setopt($ch_single, CURLOPT_URL, $oracle_single_job_api_url);
    curl_setopt($ch_single, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_single, CURLOPT_HTTPHEADER, array(
         'Authorization: Basic ' . base64_encode("$oracle_username:$oracle_password"),
    ));

    // Execute cURL session
    $api_response_for_single_job = curl_exec($ch_single);
    
    $api_response_for_single_job_json = json_decode($api_response_for_single_job, true);
    
    if (!empty($api_response_for_single_job_json['items']) && is_array($api_response_for_single_job_json['items'])) {
        $items = $api_response_for_single_job_json['items'][0] ?? null;
    } else {
        $items = null;
    }

    // Prepare parameters (same for both insert and update)
            $params = [
                $jobId,
                !empty($items['Title']) ? $items['Title'] : (!empty($job['Title']) ? $job['Title'] : null),
               !empty($items['PostedDate']) ? $items['PostedDate'] : (!empty($job['PostedDate']) ? $job['PostedDate'] : null),
                !empty($items['PostingEndDate']) ? $items['PostingEndDate'] : (!empty($job['PostingEndDate']) ? $job['PostingEndDate'] : null),
                !empty($items['Language']) ? $items['Language'] : (!empty($job['Language']) ? $job['Language'] : null),
                !empty($items['PrimaryLocationCountry']) ? $items['PrimaryLocationCountry'] : (!empty($job['PrimaryLocationCountry']) ? $job['PrimaryLocationCountry'] : null),
                !empty($items['GeographyId']) ? $items['GeographyId'] : (!empty($job['GeographyId']) ? $job['GeographyId'] : null),
                !empty($items['HotJobFlag']) ? $items['HotJobFlag'] : (!empty($job['HotJobFlag']) ? $job['HotJobFlag'] : null),
                !empty($items['WorkplaceTypeCode']) ? $items['WorkplaceTypeCode'] : (!empty($job['WorkplaceTypeCode']) ? $job['WorkplaceTypeCode'] : null),
                !empty($items['JobFamily']) ? $items['JobFamily'] : (!empty($job['JobFamily']) ? $job['JobFamily'] : null),
                !empty($items['JobFunction']) ? $items['JobFunction'] : (!empty($job['JobFunction']) ? $job['JobFunction'] : null),
                !empty($items['WorkerType']) ? $items['WorkerType'] : (!empty($job['WorkerType']) ? $job['WorkerType'] : null),
                !empty($items['ContractType']) ? $items['ContractType'] : (!empty($job['ContractType']) ? $job['ContractType'] : null),
                !empty($items['ManagerLevel']) ? $items['ManagerLevel'] : (!empty($job['ManagerLevel']) ? $job['ManagerLevel'] : null),
                !empty($items['JobSchedule']) ? $items['JobSchedule'] : (!empty($job['JobSchedule']) ? $job['JobSchedule'] : null),
                !empty($items['JobShift']) ? $items['JobShift'] : (!empty($job['JobShift']) ? $job['JobShift'] : null),
                !empty($items['JobType']) ? $items['JobType'] : (!empty($job['JobType']) ? $job['JobType'] : null),
                !empty($items['StudyLevel']) ? $items['StudyLevel'] : (!empty($job['StudyLevel']) ? $job['StudyLevel'] : null),
                !empty($items['DomesticTravelRequired']) ? $items['DomesticTravelRequired'] : (!empty($job['DomesticTravelRequired']) ? $job['DomesticTravelRequired'] : null),
                !empty($items['InternationalTravelRequired']) ? $items['InternationalTravelRequired'] : (!empty($job['InternationalTravelRequired']) ? $job['InternationalTravelRequired'] : null),
                !empty($items['WorkDurationYears']) ? $items['WorkDurationYears'] : (!empty($job['WorkDurationYears']) ? $job['WorkDurationYears'] : null),
                !empty($items['WorkDurationMonths']) ? $items['WorkDurationMonths'] : (!empty($job['WorkDurationMonths']) ? $job['WorkDurationMonths'] : null),
                // !empty($items['WorkHours']) ? $items['WorkHours'] : (!empty($job['WorkHours']) ? $job['WorkHours'] : null),
                // !empty($items['WorkDays']) ? $items['WorkDays'] : (!empty($job['WorkDays']) ? $job['WorkDays'] : null),
                // !empty($items['Department']) ? $items['Department'] : (!empty($job['Department']) ? $job['Department'] : null),
                // !empty($items['Organization']) ? $items['Organization'] : (!empty($job['Organization']) ? $job['Organization'] : null),
                // !empty($items['MediaThumbUrl']) ? $items['MediaThumbUrl'] : (!empty($job['MediaThumbUrl']) ? $job['MediaThumbUrl'] : null),
                !empty($items['ShortDescriptionStr']) ? $items['ShortDescriptionStr'] : (!empty($job['ShortDescriptionStr']) ? $job['ShortDescriptionStr'] : null),
                !empty($items['PrimaryLocation']) ? $items['PrimaryLocation'] : (!empty($job['PrimaryLocation']) ? $job['PrimaryLocation'] : null),
                !empty($items['Distance']) ? $items['Distance'] : (!empty($job['Distance']) ? $job['Distance'] : null),
                !empty($items['TrendingFlag']) ? $items['TrendingFlag'] : (!empty($job['TrendingFlag']) ? $job['TrendingFlag'] : null),
                !empty($items['BeFirstToApplyFlag']) ? $items['BeFirstToApplyFlag'] : (!empty($job['BeFirstToApplyFlag']) ? $job['BeFirstToApplyFlag'] : null),
                !empty($items['Relevancy']) ? $items['Relevancy'] : (!empty($job['Relevancy']) ? $job['Relevancy'] : null),
                !empty($items['WorkplaceType']) ? $items['WorkplaceType'] : (!empty($job['WorkplaceType']) ? $job['WorkplaceType'] : null),
                !empty($items['ExternalQualificationsStr']) ? $items['ExternalQualificationsStr'] : (!empty($job['ExternalQualificationsStr']) ? $job['ExternalQualificationsStr'] : null),
                !empty($items['ExternalResponsibilitiesStr']) ? $items['ExternalResponsibilitiesStr'] : (!empty($job['ExternalResponsibilitiesStr']) ? $job['ExternalResponsibilitiesStr'] : null),
                !empty($items['SecondaryLocations']) && !empty($items['SecondaryLocations']) ? json_encode($items['SecondaryLocations']) : (!empty($job['SecondaryLocations']) && !empty($job['SecondaryLocations']) ? json_encode($job['SecondaryLocations']) : null),
                !empty($items['Category']) ? $items['Category'] : (!empty($job['Category']) ? $job['Category'] : null),
                !empty($items['RequisitionType']) ? $items['RequisitionType'] : (!empty($job['RequisitionType']) ? $job['RequisitionType'] : null),
                !empty($items['JobGrade']) ? $items['JobGrade'] : (!empty($job['JobGrade']) ? $job['JobGrade'] : null),
                !empty($items['RequisitionId']) ? $items['RequisitionId'] : (!empty($job['RequisitionId']) ? $job['RequisitionId'] : null),
                !empty($items['ExternalPostedStartDate']) ? $items['ExternalPostedStartDate'] : (!empty($job['ExternalPostedStartDate']) ? $job['ExternalPostedStartDate'] : null),
                !empty($items['JobLevel']) ? $items['JobLevel'] : (!empty($job['JobLevel']) ? $job['JobLevel'] : null),
                !empty($items['ExternalContactName']) ? $items['ExternalContactName'] : (!empty($job['ExternalContactName']) ? $job['ExternalContactName'] : null),
                !empty($items['ExternalContactEmail']) ? $items['ExternalContactEmail'] : (!empty($job['ExternalContactEmail']) ? $job['ExternalContactEmail'] : null),
                !empty($items['ExternalPostedEndDate']) ? $items['ExternalPostedEndDate'] : (!empty($job['ExternalPostedEndDate']) ? $job['ExternalPostedEndDate'] : null),
                !empty($items['JobFamilyId']) ? $items['JobFamilyId'] : (!empty($job['JobFamilyId']) ? $job['JobFamilyId'] : null),
                !empty($items['GeographyNodeId']) ? $items['GeographyNodeId'] : (!empty($job['GeographyNodeId']) ? $job['GeographyNodeId'] : null),
                !empty($items['ExternalDescriptionStr']) ? $items['ExternalDescriptionStr'] : (!empty($job['ExternalDescriptionStr']) ? $job['ExternalDescriptionStr'] : null),
                !empty($items['CorporateDescriptionStr']) ? $items['CorporateDescriptionStr'] : (!empty($job['CorporateDescriptionStr']) ? $job['CorporateDescriptionStr'] : null),
                !empty($items['OrganizationDescriptionStr']) ? $items['OrganizationDescriptionStr'] : (!empty($job['OrganizationDescriptionStr']) ? $job['OrganizationDescriptionStr'] : null),
                !empty($items['ContentLocale']) ? $items['ContentLocale'] : (!empty($job['ContentLocale']) ? $job['ContentLocale'] : null),
                !empty($items['ObjectVerNumberProfile']) ? $items['ObjectVerNumberProfile'] : (!empty($job['ObjectVerNumberProfile']) ? $job['ObjectVerNumberProfile'] : null),
                !empty($items['ApplyWhenNotPostedFlag']) ? $items['ApplyWhenNotPostedFlag'] : (!empty($job['ApplyWhenNotPostedFlag']) ? $job['ApplyWhenNotPostedFlag'] : null),
                !empty($items['InternalQualificationsStr']) ? $items['InternalQualificationsStr'] : (!empty($job['InternalQualificationsStr']) ? $job['InternalQualificationsStr'] : null),
                !empty($items['InternalResponsibilitiesStr']) ? $items['InternalResponsibilitiesStr'] : (!empty($job['InternalResponsibilitiesStr']) ? $job['InternalResponsibilitiesStr'] : null),
                !empty($items['requisitionFlexFields']) && !empty($items['requisitionFlexFields']) ? json_encode($items['requisitionFlexFields']) : (!empty($job['requisitionFlexFields']) && !empty($job['requisitionFlexFields']) ? json_encode($job['requisitionFlexFields']) : null),
                !empty($items['skills']) && !empty($items['skills']) ? json_encode($items['skills']) : (!empty($job['skills']) && !empty($job['skills']) ? json_encode($job['skills']) : null),
            ];
    
    $types = str_repeat("s", count($params));
    
    if ($exists == 0) {
        // INSERT new record
        $insert_stmt->bind_param($types, ...$params);
        if (!$insert_stmt->execute()) {
            $error_message = "Insert failed for job $jobId: " . $insert_stmt->error;
            sendErrorMailForCron('DB Insert Execution', $instance, $manual_cron_url, $error_message);
        }
    } else {
        // UPDATE existing record
        // Add jobId to the end of params for WHERE clause
        $params[] = $jobId;
        $update_types = $types . "s"; // Add one more string type for WHERE clause
        
        $update_stmt->bind_param($update_types, ...$params);
        if (!$update_stmt->execute()) {
            $error_message = "Update failed for job $jobId: " . $update_stmt->error;
            sendErrorMailForCron('DB Update Execution', $instance, $manual_cron_url, $error_message);
        }
    }
}

    
    // Cleanup
$check_stmt->close();
$insert_stmt->close();
$update_stmt->close();
    $conn->close();
    $end_time = microtime(true);
    $execution_time = $end_time - $start_time;
    
    // echo "running and fetching ". $offset;
    // echo '<br>';


}  while ($hasMoreRecords);



 // Prepare success message
    $log_message = json_encode([
        "status" => "success",
        "message" => "Jobs fetched and saved in database successfully from oracle",
        "instance" => $instance,
        "total jobs fetched" => $total_actual_fetched,
        "execution_time" => "".round($execution_time)." seconds"
    ], JSON_PRETTY_PRINT);
    
    
     $timestamp = date('Y-m-d H:i:s');
        $log_entry = "[$timestamp] $log_message" . PHP_EOL;
    
    // Write the log entry
    file_put_contents($_SERVER['DOCUMENT_ROOT']. '/cron_logs/oracle.log', $log_entry, FILE_APPEND);
        
        


    // Return the response as JSON
    echo $log_message;


function checkTotalJobsInPortal() {
    global $oracle_api_url, $limit, $offset, $sorting; // Ensure global variables are accessible
    
    $oracle_api_url_paginated = $oracle_api_url . ',limit=' . $limit . ',offset=' . $offset . ',sortBy=' . $sorting;

    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $oracle_api_url_paginated);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    // Execute cURL session
    $api_response = curl_exec($ch);
    if (curl_errno($ch)) {
        die(json_encode(["error" => "cURL error: " . curl_error($ch)]));
    }
    
    curl_close($ch); // Close the cURL session
    
    $decoded_response = json_decode($api_response, true);

    // Ensure key exists before accessing it
    if (isset($decoded_response['items'][0]['TotalJobsCount'])) {
        return $decoded_response['items'][0]['TotalJobsCount'];
    } else {
        return 0; // Return 0 if not found
    }
}



function addMissingColumns($conn, $table_name, $columns) {
        $existing_columns = [];
        $result = $conn->query("SHOW COLUMNS FROM `$table_name`");
    
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $existing_columns[$row['Field']] = $row['Type'];
            }
        }
    
        $errors = [];
        foreach ($columns as $column => $type) {
            if (!array_key_exists($column, $existing_columns)) {
                $sql = "ALTER TABLE `$table_name` ADD COLUMN `$column` $type";
                if (!$conn->query($sql)) {
                    $errors[] = "Error adding column `$column` with type `$type`: " . $conn->error;
                }
            }
        }
        
        return empty($errors) ? true : $errors;
    }
   
?>