<!doctype html>
<html lang="en">

<head>
    <title>Job Details - Artech</title>
     <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/header.php');
     
      
      ?>
</head>

<body class="artech-job">
    <script>
document.addEventListener("DOMContentLoaded", function() {
  const dropZone = document.getElementById("dropZone");
  const fileInput = document.getElementById("upload_image_logo");
  const uploadGallery = document.getElementById("upload_gallery");

  if (!dropZone || !fileInput || !uploadGallery) return;

  // Prevent defaults
  ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
    dropZone.addEventListener(eventName, preventDefaults, false);
  });

  function preventDefaults(e) {
    e.preventDefault();
    e.stopPropagation();
  }

  // Highlight on drag
  ['dragenter', 'dragover'].forEach(eventName => {
    dropZone.addEventListener(eventName, () => dropZone.classList.add('highlight'), false);
  });

  ['dragleave', 'drop'].forEach(eventName => {
    dropZone.addEventListener(eventName, () => dropZone.classList.remove('highlight'), false);
  });

  // Handle file drop
  dropZone.addEventListener('drop', function(e) {
    const dt = e.dataTransfer;
    const files = dt.files;
    if (files.length) {
      fileInput.files = files;
      showUploadedFiles(files);
    }
  });

  // Handle normal file selection
  fileInput.addEventListener('change', function(e) {
    if (fileInput.files.length) {
      showUploadedFiles(fileInput.files);
    }
  });

  // Show uploaded file names
  function showUploadedFiles(files) {
    uploadGallery.innerHTML = ''; // Clear previous files
    Array.from(files).forEach(file => {
      const fileBox = document.createElement('div');
      fileBox.className = 'uploaded-file-box p-2 border rounded small';
      fileBox.innerText = file.name;
      uploadGallery.appendChild(fileBox);
    });
  }
  
  
      document.getElementById('dropZone').addEventListener('click', function(e) {
    // Only trigger if clicking on the container or non-input elements
  
    if (!e.target.closest('input[type="file"]')) {
      document.getElementById('upload_image_logo').click();
    }
  });
});
</script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/navbar.php'); ?>
    <div class="full-loader-wrapper">
        <span class="loader"></span>
    </div>

    <!-- =====Header Part==== -->
    <section class="job-detail-header py-5 mb-5">
        <div class="container">
            <div class="py-5 text-center">
                <h1 class="job-title text-white mb-2"></h1>
                <p class="job-location text-white mb-2"></p>
                <p class="text-white mb-2 fs-12"></p>
            </div>
        </div>
    </section>
    <!-- ========================= -->

    <!-- =======Job List Content======= -->
    <div class="container">
        <section class="m-3">
            <div class="row">
                <div class="col-md-12">
                    <div class="card mt--100">
                        <div class="card-body">
                            <div id="job-details">

                            </div>
                            <div class="card mt-4 p-2">
                                <div class="card-body py-4">
                                    <div class="col-md-12 mb-4">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h3 class="fs-20 fw-500">Apply now</h3>
                                                <span>All fields marked with an asterisk (*) are required.</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <form action="" id="job_apply_form"  enctype="multipart/form-data">
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <input type="text" for="firstName" name="firstName" class="form-control fs-16"
                                                        placeholder="First Name*" required >
                                                </div>
                                                <div class="col-md-6  mb-3">
                                                    <input type="text" class="form-control fs-16"
                                                        placeholder="Last Name*"  name="lastName" required>
                                                </div>
                                                <div class="col-md-6  mb-3">
                                                    <input type="email"  id="email" class="form-control fs-16"
                                                        placeholder="Email ID*"  name="email" required>
                                                </div>
                                                 <div class="col-md-6  mb-3">
                                                    <input type="verify-email" id="verify-email" class="form-control fs-16"
                                                        placeholder="Verify Email*"  name="verify-email" required>
                                                </div>
                                                <div class="col-12 mb-3">
                                                    <span id="email-error" class="email-error" style="color: red; font-size: 14px;"></span>
                                                </div>
                                                <div class="col-md-6  mb-3">
                                                    <input type="number" class="form-control fs-16"
                                                        placeholder="Phone No"  name="phone">
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                  <select class="form-control fs-16" name="state" required>
                                                    <option value="">Select State*</option>
                                                    <option value="Andaman and Nicobar Islands">Andaman and Nicobar Islands</option>
                                                    <option value="Andhra Pradesh">Andhra Pradesh</option>
                                                    <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                                                    <option value="Assam">Assam</option>
                                                    <option value="Bihar">Bihar</option>
                                                    <option value="Chandigarh">Chandigarh</option>
                                                    <option value="Chhattisgarh">Chhattisgarh</option>
                                                    <option value="Dadra and Nagar Haveli and Daman and Diu">Dadra and Nagar Haveli and Daman and Diu</option>
                                                    <option value="Delhi">Delhi</option>
                                                    <option value="Goa">Goa</option>
                                                    <option value="Gujarat">Gujarat</option>
                                                    <option value="Haryana">Haryana</option>
                                                    <option value="Himachal Pradesh">Himachal Pradesh</option>
                                                    <option value="Jammu and Kashmir">Jammu and Kashmir</option>
                                                    <option value="Jharkhand">Jharkhand</option>
                                                    <option value="Karnataka">Karnataka</option>
                                                    <option value="Kerala">Kerala</option>
                                                    <option value="Ladakh">Ladakh</option>
                                                    <option value="Lakshadweep">Lakshadweep</option>
                                                    <option value="Madhya Pradesh">Madhya Pradesh</option>
                                                    <option value="Maharashtra">Maharashtra</option>
                                                    <option value="Manipur">Manipur</option>
                                                    <option value="Meghalaya">Meghalaya</option>
                                                    <option value="Mizoram">Mizoram</option>
                                                    <option value="Nagaland">Nagaland</option>
                                                    <option value="Odisha">Odisha</option>
                                                    <option value="Puducherry">Puducherry</option>
                                                    <option value="Punjab">Punjab</option>
                                                    <option value="Rajasthan">Rajasthan</option>
                                                    <option value="Sikkim">Sikkim</option>
                                                    <option value="Tamil Nadu">Tamil Nadu</option>
                                                    <option value="Telangana">Telangana</option>
                                                    <option value="Tripura">Tripura</option>
                                                    <option value="Uttar Pradesh">Uttar Pradesh</option>
                                                    <option value="Uttarakhand">Uttarakhand</option>
                                                    <option value="West Bengal">West Bengal</option>
                                                  </select>
                                                </div>


                                                <div class="col-md-6  mb-3">
                                                    <input type="text" class="form-control fs-16"
                                                        placeholder="City*"  name="city" required>
                                                </div>
                                                 <div class="col-md-6  mb-3">
                                                    <input type="number" class="form-control fs-16"
                                                        placeholder="Zip Code*"  name="zip" required>
                                                </div>
                                                <!--<div class="col-md-12  mb-3">-->
                                                <!--    <input type="text" class="form-control fs-16"-->
                                                <!--        placeholder="Additional Info*"  name="info" required>-->
                                                <!--</div>-->
                                                 <div class="col-md-12 mb-3">
                                                    <select id="domain" name="domain" class="form-control" required>
                                                        <option value="">Select Domain</option>
                                                        <option value="Administration">Administration</option>
                                                        <option value="Finance">Finance</option>
                                                        <option value="Human Resources">Human Resources</option>
                                                        <option value="Marketing">Marketing</option>
                                                        <option value="Recruiting">Recruiting</option>
                                                        <option value="Others">Others</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12">
                                                    <fieldset class="upload_dropZone text-center mb-3 p-4" id="dropZone">
                                                        <legend class="visually-hidden">Upload Your Resume</legend>
                                                         
                                                        <div class="upload-content">
                                                          <img src="/images/upload.svg" alt="Upload Icon" class="mb-3" />
                                                         
                                                          <p class="small mb-2 text-grey">
                                                            Select a file from your device to upload your resume. <br>
                                                            We accept <strong>.DOC, .DOCX</strong>, and <strong>PDF</strong> files up to 1MB. <br>
                                                            <em>Images or scanned documents are not accepted.</em>
                                                          </p>
                                                         
                                                          <input 
                                                            type="file" 
                                                            id="upload_image_logo" 
                                                            name="file" 
                                                            class="position-absolute invisible" 
                                                            data-post-name="image_logo"
                                                            data-post-url="https://someplace.com/image/uploads/logos/"
                                                            accept="image/jpeg, image/png, image/svg+xml, application/pdf" 
                                                            multiple 
                                                          />
                                                         
                                                          <label for="upload_image_logo" class="browse-label">
                                                            <i class="text-grey">or</i> 
                                                            <span class="text-voilet">browse your device</span>
                                                          </label>
                                                          <div id="upload_gallery" class="upload_gallery d-flex flex-wrap justify-content-center gap-3 mb-0 mt-3"></div>
                                                        </div>
                                                     </fieldset>

                                                      <div style="font-size:12.5px" id="file-upload-ack" class="mt-3 mb-2 text-success"></div>
                                                </div>
                                              
                                                <div class="col-md-12 mb-3 px-4">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" id="consentCheckbox" checked>
                                                        <label style="text-align:justify; font-size: 13px !important;" class="form-check-label" for="consentCheckbox">
                                                            By checking this box, you agree to receive calls, AI-generated calls, text messages, or emails from Artech and its affiliates, and contracted partners. Frequency varies for text messages. Message and data rates may apply. Carriers are not liable for delayed or undelivered messages. You can reply STOP to cancel and HELP for help. You can access our privacy policy at 
                                                            <a style=" font-size: 13px !important; color: rgba(37, 62, 145, 1)"  href="https://www.artech.com/privacy-policy/" target="_blank">https://www.artech.com/privacy-policy/</a>.
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 text-center">
                                                    <button type="submit" id ="jobApplybtn" class="btn btn-jl-common">Submit</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<div id="closedJobModal" style="
    display: none; 
    position: fixed; 
    top: 0; 
    left: 0; 
    width: 100%; 
    height: 100%; 
    background: rgba(0, 0, 0, 0.6); 
    z-index: 9999; 
    justify-content: center; 
    align-items: center; 
    padding: 20px; 
    box-sizing: border-box;
    overflow-y: auto;
">
  <div style="
      background: #fff; 
      padding: 40px 30px; 
      max-width: 600px; 
      width: 100%; 
      border-radius: 12px; 
      text-align: center; 
      box-shadow: 0 6px 20px rgba(0,0,0,0.1); 
      position: relative;
      animation: fadeInScale 0.3s ease;
  ">
    <h2 style="
        font-size: 26px; 
        font-weight: 700; 
        margin-bottom: 20px; 
        color: #333;
    ">This Job Is No Longer Available</h2>

    <p style="
        font-size: 16px; 
        color: #666; 
        line-height: 1.6; 
        margin-bottom: 25px;
    ">
      Looks like this position has been filled or closed. <br> But don’t worry — there are plenty of exciting opportunities waiting for you!
      <br><br>
      Stay in the loop by submitting your resume — we’ll notify you when roles matching your skills and goals open up.
    </p>

    <button style="

        font-weight: 600;
        cursor: pointer;
        transition: background 0.3s ease;
    " 
    class="btn btn-jl-common" 
    onclick="handleSubmitResume()">
      Submit your resume
    </button>
  </div>
</div>

<style>
@keyframes fadeInScale {
    0% { opacity: 0; transform: scale(0.9); }
    100% { opacity: 1; transform: scale(1); }
}
</style>
    <!-- ========================= -->

    <?php include_once('includesnew/footer.php') ?>

</body>

</html>

<script>

function showClosedJobModal() {
    document.getElementById('closedJobModal').style.display = 'flex';
}

function handleSubmitResume() {
    const currentPath = window.location.pathname.split('/').slice(0, 2).join('/');
    window.location.href = `${currentPath}/join-our-network`;
}


    $(document).ready(function () {
        const pathArray = window.location.pathname.split('/');
        const lastPart = pathArray.filter(part => part !== "").pop(); // Get the last non-empty segment

        // Extract only the numeric job ID from the last part
        const jobIdMatch = lastPart.match(/(\d+)$/); // Find the last set of digits
        const jobId = jobIdMatch ? jobIdMatch[0] : null; // Extract job ID 
        
        
        $.ajax({
            url: 'oracle_single_job_api.php',
            type: 'GET',
            data: {
                jobId: jobId
            },
            success: function (response) {
                const res = JSON.parse(response);
                const job = res.job;
                renderJobDetails(job);
                 $(".full-loader-wrapper").addClass('d-none');
            }
        });

        function renderJobDetails(job) {
            if (job.postingEndDate) {
                 const today = new Date();
                 const postingEndDate = new Date(job.postingEndDate);
         
                 if (postingEndDate < today) {
                     showClosedJobModal();
                     return; // Stop rendering if job is closed
                 }
             }
            const jobData = `
                <div class="row" id="jobDetailBlock" data-posting-end-date=${job.postingEndDate} data-job-id=${job.id}>
                    <div class="col-md-6">
                        <p class="fw-700 fs-18">${job.title}</p>
                        <p class="mb-0 fs-12 text-grey">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
                                <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
                                <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
                            </svg>
                            &nbsp; ${job.primaryLocation}
                        </p>
                    </div>
                    <div class="col-md-6 m-auto text-end">
                        <button class="btn btn-jl-common redirect-down">Apply Now</button>
                        <a href="#" class="share-job" data-job-id="${job.id}"><img src="images/share.svg" class="w-10" alt=""></a>
                    </div>
                </div>
                <hr>
                <div class="col-md-12 p-2">
                    <p class="fs-18 fw-500 mb-2">Job Description</p>
                    <p class="job-title text-grey mb-2">${job.title}</p>
                    <p><span class="fw-500 mb-2">Duration :</span><span class="text-grey"></span></p>
                    <p class="text-grey"></p>
                </div>
                ${job.externalDescriptionStr ? `
                    <div class="col-md-12 p-2 mt-4">
                        <h3 class="fs-20 fw-500">Summary</h3>
                        <p class="mb-0 text-grey">${job.externalDescriptionStr}</p>
                    </div>
                ` : ''}
                ${job.corporateDescriptionStr ? `
                    <div class="col-md-12 p-2 mt-4">
                        <h3 class="fs-20 fw-500">Roles & Responsibilities</h3>
                        <p class="mb-0 text-grey">${job.corporateDescriptionStr}</p>
                    </div>
                ` : ''}
            `;
            $('#job-details').append(jobData);

            $('.job-title').text(job.title);
            $('.job-location').text(job.primaryLocation);
        }

        $(document).on('click', '.share-job', function (e) {
            e.preventDefault();
            const jobId = $(this).data('job-id');
            const currentUrl = new URL(window.location.href);
            currentUrl.searchParams.set('job_id', jobId);
            const shareUrl = currentUrl.toString();

            navigator.clipboard.writeText(shareUrl).then(() => {
                Swal.fire({
                    title: 'Success!',
                    text: 'Link copied to clipboard',
                    icon: 'success',
                    confirmButtonText: 'Cool'
                });
            }).catch(err => {
                console.error('Failed to copy: ', err);
            });
        });

         $('#job_apply_form').on('submit', function(e) {
             e.preventDefault();
              $(".full-loader-wrapper").removeClass('d-none');
             
             const consent_value = $('#consentCheckbox').is(':checked') ? 1 : 0;
             // Initialize FormData to handle the form and file
             const jobId = $('#jobDetailBlock').attr('data-job-id'); // Get job ID
             const formData = new FormData(this); // Create a FormData object
             formData.append('jobId', jobId); // Add the jobId to the FormData object
              formData.append('communication_consent', consent_value); 
              const url = window.location.pathname;
             // Get the first segment dynamically
             const firstPathSegment = url.split("/").filter((part) => part !== "")[0];
         
             if (!firstPathSegment) {
               console.error("Invalid URL structure.");
               handlePageWithoutJobsPath();
               return;
             }
   
               
             // Make AJAX request
             $.ajax({
                 url: "/" + firstPathSegment + "/oracle_apply_job.php", // Backend URL
                 type: "POST",
                 data: formData, // Use FormData object
                 dataType: 'json',
                 contentType: false, // Let jQuery set the content type to multipart/form-data
                 processData: false, // Prevent jQuery from converting FormData into a query string
                 success: function(response) {
                      $(".full-loader-wrapper").addClass('d-none');
                     if(response.success){
                         
                           Swal.fire({
                       
                        text: `${response.message}`,
                        icon: 'success',
                        confirmButtonText: 'Okay',
                        customClass: {
                          htmlContainer: 'bold-text'
                         }
         
                     }).then(() => {
                         // After the user clicks "Cool" on the success alert:
                         setHasAppliedLocalStorage()
                         // 1. Reset the form
                         $('#job_apply_form')[0].reset();
                         
                         // 2. Redirect to the job list page
                         window.location.href = window.location.origin + "/" + firstPathSegment;
         
                         
                     });
                         
                     }else {
                         
                        Swal.fire({
                           title: 'Error!',
                           text: `${response.message}`,
                           icon: 'error',
                           confirmButtonText: 'Okay'
                        });
                     }
                   
                     
                 },
                 error: function(xhr, status, error) {
                     Swal.fire({
                        title: 'Error!',
                        text: 'Something went wrong. Please try again.',
                        icon: 'error',
                        confirmButtonText: 'Okay'
                     });
                 }
             });
         });
    });
    
    
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('#job_apply_form');
    const email = document.getElementById('email');
    const verifyEmail = document.getElementById('verify-email');
    const emailError = document.getElementById('email-error');

    function validateEmails() {
        const emailVal = email.value.trim();
        const verifyVal = verifyEmail.value.trim();

        emailError.textContent = "";
        verifyEmail.classList.remove('is-invalid');

        if (verifyVal === "") {
            // Nothing typed yet
            return;
        }

        // Check character-by-character match
        if (!emailVal.startsWith(verifyVal)) {
            emailError.textContent = "Email and Verify Email do not match.";
            verifyEmail.classList.add('is-invalid');
        }
    }

    email.addEventListener('input', validateEmails);
    verifyEmail.addEventListener('input', validateEmails);

    form.addEventListener('submit', function(e) {
        const emailVal = email.value.trim();
        const verifyVal = verifyEmail.value.trim();
        
        if (emailVal !== verifyVal) {
            e.preventDefault();
            emailError.textContent = "Email and Verify Email do not match.";
            verifyEmail.classList.add('is-invalid');
            verifyEmail.focus();
        }
    });
});


$(document).on('click', '.redirect-down', function(e) {
    e.preventDefault();
    const firstNameInput = $('input[name="firstName"]');
    if (firstNameInput.length) {
        $('html, body').animate({
            scrollTop: firstNameInput.offset().top - 100 // adjust offset if needed
        }, 500); // 500ms animation
        firstNameInput.focus();
    }
});
</script>
