<!doctype html>
<html lang="en">

<head>
    <title>Job list-Artech</title>
  
     <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/header.php'); 


 include_once($_SERVER['DOCUMENT_ROOT'] . '/config.php');
 

?>
</head>

<body class="artech-job">
    <script>
       //   for the consent box
   document.addEventListener("DOMContentLoaded", function () {
    const closeBtn = document.querySelector(".message-banner-close-btn");
    const banner = document.getElementById("banner_consent");

    // Check if cookie is already set
    const isBannerClosed = document.cookie.split('; ').find(row => row.startsWith('banner_consent='));

    if (isBannerClosed && banner) {
      banner.style.display = "none"; // Hide banner if cookie found
    }

    if (closeBtn && banner) {
      closeBtn.addEventListener("click", function () {
        banner.style.transition = "all 0.5s ease";
        banner.style.transform = "translateY(-20px)";
        banner.style.opacity = "0";

        setTimeout(function () {
          banner.remove(); // Remove after animation
        }, 500);

        // Set cookie to remember that user closed it
        document.cookie = "banner_consent=1; path=/; max-age=" + 60 * 60 * 24 * 7; // 7 days
      });
    }
  });
  </script>
  
    <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/navbar.php'); ?>
    <!-- =====Header Part==== -->
   <section class="jobheader py-5">
    <div class="container">
        <div class="text-white my-2">
            <a class="text-white" href="https://artech.com/">HOME</a> > <a class="text-white" href="https://www.artech.com/careers/">CAREERS</a> > <a class="text-white" id="breadcrumb-job-type" href="#"></a> > <a class="text-white" id="breadcrumb-job-country" href="#"></a>
        </div>
        <div class="py-5 pb-2">
            <h1 class="text-white mb-4 " id="main-heading"></h1>
            <p class="text-white" id="banner-description">
                
            </p> 
        </div>
    </div>

</section>
    <!-- ========================= -->
    <!-- =======Job List Content======= -->
    <div class="container">
        <section class="mb-3 d-none d-lg-block">
        </section>
        <!-- =====For Mobile & Tab==== -->
        <section class="mb-3 d-sm-none d-md-none d-lg-none">
            <div class="col-md-12 text-end">
                <button class="btn btn-jl-common" onclick="jltoggle()"><svg xmlns="http://www.w3.org/2000/svg"
                        width="16" height="16" fill="currentColor" class="bi bi-list" viewBox="0 0 16 16">
                        <path fill-rule="evenodd"
                            d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                    </svg></button>
            </div>
            <div class="row" id="contentBox" style="display: none;">
                <div class="col-md-12 mb-3 mt-3 bdr-1">
                    <ul class="contentBox-content">
                        <li><a href="#">Create Job Alert</a></li>
                        <li><a href="#">Search Jobs</a></li>
                        <li><a href="#">Sign In</a></li>
                        <li><a href="#">Register With Us</a></li>
                        <li><a href="#">Language</a></li>
                    </ul>
                </div>
            </div>
        </section>
        <!-- ========================= -->
        <section class="joblist-container">
            <div class="row ">
                <div class="col-md-12 mb-3 bdr-1">
                    <form action="" id="job-search-form">
                        <div class="row">
                            <div class="col-md-8 ">
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon1"><img src="<?php echo $site_url; ?>/images/search.svg"
                                            alt=""></span>
                                    <input id="search-keyword" type="text" class="form-control jl-search"
                                        placeholder="Keywords"
                                        aria-label="Keywords" aria-describedby="basic-addon1">
                                </div>
                            </div>
                       
                            <div class="col-md-4 m-auto text-end">
                                <button class="btn btn-jl-common">Find Jobs</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-md-3 px-0">
                    <form action="">
                        <select multiple name="" data-group="title" id="categories" class="form-control form-select jl-search">

                        </select>
                    </form>
                </div>
                <div class="col-md-3">
                    <form action="">
                        <select multiple name=""  data-group="location" id="location" class="locations form-control form-select jl-search">
                            
                        </select>
                    </form>
                </div>
           
                <!--<div class="col-md-2  text-right">-->

                <!--<span class="jobs-count"></span>-->
                <!--</div>-->
            </div>
        </section>
        
        
                <section class="message-banner" id="banner_consent">
          <span class="message-banner-close-btn">&times;</span>
          <div class="message-banner-content">
              <p ><span style="color: red;">Please be advised that any emails or communication from the ‘@artechcareers.com’ domain is not connected to Artech LLC or any of its subsidiaries. These messages do not reflect legitimate job opportunities or accurate information regarding positions with our company.</span> If you receive any emails (may include, but not limited to job offers or requests for any information or payments) from the ‘@artechcareers.com’ domain, or any domain other than @artech.com, immediately send an email to <a href="email:employmentVerification@artech.com">EmploymentVerification@artech.com</a> to either inform us or verify if the communication is legit or not from Artech.
    To apply with us, visit our website at <a href="www.artech.com/careers/">www.artech.com/careers/</a> for more information.</p>
           </div>
        
         </section>
        
        <section class="col-md-12" style="display: flex;justify-content: end;" >
            <h2 style="text-align: right;" id="dynamic_title" class="page-text-heading mx-2 mb-2 fs-14"></h2> <span class="jobs-count mx-2 mb-2 fs-14"></span>
        </section>
        
        <section class="mb-5">
            <div class="row d-flex align-items-start">
                <div id="no-job" class="col-md-12 text-center">
                    <span>No jobs found!</span>
                </div>
                <div class="col-md-12 text-center">
                    <span class="loader"></span>
                </div>
               <div class="col-md-12 px-0">
                    <div id="jobs-container" class="nav nav-pills flex-grid" id="v-pills-tab" role="tablist" aria-orientation="vertical">

                  
                    </div>
                </div>
                <div class="col-md-12 px-0 mt-4">
                    <div class="container d-flex space-between" style="    background: #ebebeb;
    border: 1px solid rgb(229 229 229 / 20%);
    padding: 20px;
    border-radius: 20px;
display: flex; justify-content: space-between; align-items: center;">
    <div>
        <p style="font-weight: bold; font-size: 24px; margin: 0;">Can’t Find the Right Role?</p>
        <span style="font-size: 16px; color: #555;">Stay updated on opportunities that match your skills and goals.</span>
    </div>
    <div>
        <button  onclick="handleSubmitResume()" class="btn btn-jl-common" style="padding: 10px 20px; font-size: 16px; color: white; border: none; cursor: pointer;">
            Submit your resume
        </button>
    </div>
</div>
            </div>
                
            </div>
        </section>
        
           <section style="display: flex; justify-content: end;">
        <div id="pagination-container"></div>

            <style>
                #pagination-container {
                    display: flex;
                    justify-content: center;
                    margin-top: 20px;
                    flex-wrap: wrap;
                }
                .pagination-btn {
                    padding: 8px 12px;
                    min-width:40px;
                    margin: 4px;
                    border: 1px solid #ccc;
                    color: #333;
                    cursor: pointer;
                    border-radius: 4px;
                    user-select: none;
                    text-align:center;
                }
                .pagination-btn.active {
                    background-color: rgba(37, 62, 145, 1);
                    color: #fff;
                    border-color: rgba(37, 62, 145, 1);
                }
                .pagination-btn.disabled {
                    opacity: 0.5;
                    pointer-events: none;
                }
            </style>

    </section>
    </div>
    
    
    <!-- ========================= -->
    <?php include_once($_SERVER['DOCUMENT_ROOT'] . '/includesnew/footer.php') ?>
</body>

</html>
<style>
        .job-container {
            cursor: pointer;
        }
        #no-job{
            display:none;
        }

        
        #search-keyword{
           width:auto;
        }
        #search-keyword:focus{
           background-color: transparent;
        }
</style>

<script>
function handleSubmitResume() {
    const currentPath = window.location.pathname.split('/').slice(0, 2).join('/');
    window.location.href = `${currentPath}/join-our-network`;
}
function renderPagination(totalCount, currentPage, onPageChange) {
    const limit = 30;
    const totalPages = Math.ceil(totalCount / limit);
    const container = document.getElementById('pagination-container');
    container.innerHTML = '';

    if (totalPages <= 1) return;
    

    container.style.marginBottom = "2rem";

    const createButton = (label, page, isActive = false, isDisabled = false) => {
        const btn = document.createElement('div');
        btn.className = 'pagination-btn';
        if (isActive) btn.classList.add('active');
        if (isDisabled) btn.classList.add('disabled');
        btn.textContent = label;
        if (!isDisabled && label !== '...') {
            btn.addEventListener('click', () => onPageChange(page));
        }
        return btn;
    };

    const addEllipsis = () => {
        const ellipsis = document.createElement('div');
        ellipsis.className = 'pagination-btn disabled';
        ellipsis.textContent = '...';
        container.appendChild(ellipsis);
    };

    // Prev button
    container.appendChild(createButton('« Prev', currentPage - 1, false, currentPage === 1));

    // Always show first page
    container.appendChild(createButton(1, 1, currentPage === 1));

    // Left ellipsis
    if (currentPage > 3) addEllipsis();

    // Middle pages
    for (let i = currentPage - 1; i <= currentPage + 1; i++) {
        if (i > 1 && i < totalPages) {
            container.appendChild(createButton(i, i, i === currentPage));
        }
    }

    // Right ellipsis
    if (currentPage < totalPages - 2) addEllipsis();

    // Always show last page
    if (totalPages > 1) {
        container.appendChild(createButton(totalPages, totalPages, currentPage === totalPages));
    }

    // Next button
    container.appendChild(createButton('Next »', currentPage + 1, false, currentPage === totalPages));
}


$(document).ready(function () {
  handleGetJobsDataByURL();

  $(".loader").addClass("active");

  function fetchData(apiUrl, params = []) {
    return $.ajax({
      url: apiUrl,
      type: "GET",
      data: params,
    });
  }

function preserveSpecialCasing(str) {
    const preservedWords = ['QA', 'UI', 'UX', 'II', 'III', 'IV', 'VI', 'VII', 'VIII', 'IX', 'X'];
    
    return str
        .split(' ')
        .map(word => {
            const upperWord = word.toUpperCase();
            return preservedWords.includes(upperWord) ? upperWord : word.toLowerCase();
        })
        .join(' ')
        .replace(/[^\w\s\-]+/g, "")      // Remove special characters
        .replace(/\s+/g, "-");           // Replace spaces with dashes
}





function updateURL(hasJobId) {
    const keyword = $("#search-keyword").val().trim().toLowerCase(); // preserve internal hyphens
    const locations = $("#location").val(); // assumed to be an array
    const categories = $("#categories").val(); // assumed to be an array

    const firstPathSegment = window.location.pathname
        .split("/")
        .filter((part) => part !== "")[0];

    let baseUrl = window.location.origin + "/" + firstPathSegment + "/";

    // Build slug from category or keyword
    const primarySearchTerm = categories && categories.length > 0
        ? encodeURIComponent(slugify(categories[0]))
        : keyword && keyword.length > 0
            ? encodeURIComponent(slugify(keyword))
            : "";

    // Build location slug from the first location
    let locationPart = "";
    if (locations && locations.length > 0) {
        const firstLocationSlug = slugify(locations[0]);
        locationPart = encodeURIComponent(firstLocationSlug);
    }

    // Build clean URL path
    if (primarySearchTerm && locationPart) {
        baseUrl += `${primarySearchTerm}-jobs-in-${locationPart}`;
    } else if (primarySearchTerm) {
        baseUrl += `${primarySearchTerm}-jobs`;
    } else if (locationPart) {
        baseUrl += `jobs-in-${locationPart}`;
    }

    // Build query parameters
    const params = new URLSearchParams();

    if (hasJobId && typeof jobId !== "undefined") {
        params.append("job_id", jobId);
    }

    if (keyword) {
        params.append("keyword", keyword);
    }

    if (categories && categories.length > 0) {
        const uniqueCategories = [...new Set(categories)];
        params.append("category", uniqueCategories.map(c => slugify(c)).join(","));
    }

    if (locations && locations.length > 0) {
        const uniqueLocations = [...new Set(locations)];
        params.append("location", uniqueLocations.map(loc => slugify(loc)).join(","));
    }


   // Final URL update
    const finalURL = baseUrl + (params.toString() ? "?" + params.toString() : "");
    window.history.replaceState({}, "", finalURL);
    

    // Trigger the page updates
    handleGetJobsDataByURL();
    updateThePageJobsHeading();
}

// Slugify helper: trims, replaces spaces/commas, collapses multiple hyphens
function slugify(str) {
    return str
        .trim()
        .toLowerCase()
        .replace(/,/g, "-")
        .replace(/\s+/g, "-")
        .replace(/-+/g, "-"); // collapses multiple hyphens into one
}



function handleGetJobsDataByURL() {
  const url = window.location.pathname;
 
  const firstPathSegment = url.split("/").filter((part) => part !== "")[0];

  if (!firstPathSegment) {
    console.error("Invalid URL structure.");
    handlePageWithoutJobsPath();
    return;
  }

  // Extract the portion after the firstPathSegment
  const rawPath = url.replace(window.location.origin, "")
    .replace(`/${firstPathSegment}/`, "")
    .replace(/[\/]+/g, "")
    .replace(/\.html$/, ""); // optional for .html suffix

  let keyword = "";
  let location = "";

  if (rawPath.includes("-jobs-in-")) {
    const [keywordPart, locationPart] = rawPath.split("-jobs-in-");
    keyword = keywordPart.replace(/-+/g, " ").trim(); // hyphens → space
    location = locationPart.replace(/-+/g, " ").trim();
  } else if (rawPath.includes("jobs-in-")) {
    location = rawPath.replace("jobs-in-", "").replace(/-+/g, " ").trim();
  } else if (rawPath.includes("-jobs")) {
    keyword = rawPath.replace("-jobs", "").replace(/-+/g, " ").trim();
  }

  // Read extra filters from query string if present
  const params = new URLSearchParams(window.location.search);
  const categoryParam = params.get("category");
  const locationParam = params.get("location");

  const titleParams = categoryParam
    ? categoryParam.split(",").map(c => c.replace(/-+/g, " ").trim())
    : [];

  const locationArray = locationParam
    ? locationParam.split(",").map(loc => loc.replace(/-+/g, " ").trim())
    : location
    ? [location.trim()]
    : [];

  // Make the API call
  fetchData("/" + firstPathSegment + "/oracle_api.php", {
    searchTerm: keyword,
    locationValues: JSON.stringify(locationArray),
    titleValues: JSON.stringify(titleParams)
  })
    .done(handleApiResponse)
    .fail(handleError);
}


  function handleApiResponse(data) {
    const parsedData = JSON.parse(data);
 const allJobs = parsedData.jobs;

const today = new Date();

const jobs = allJobs.filter(job => {
  const endDate = job.postingEndDate ? new Date(job.postingEndDate) : null;

  // Include job if endDate is null OR it's before today
  return !endDate || endDate > today;
});

    
    if (jobs.length == 0) {
      $("#no-job").css("display", "block");
      $(".list-scroll").css("display", "none");
             $(".jobs-count").text(``);
       $("#dynamic_title").text(``);
    } else {
      $("#no-job").css("display", "none");
      $(".list-scroll").css("display", "block");
    }
// console.log(jobs)
    renderJobElements(jobs);

     const totalCount = parsedData.totalCount;
     const currentPage = parsedData.currentPage;
    
     
     if (jobs.length === 0 && !sessionStorage.getItem(getSessionKey('noAvailableJobs'))) {
       showSubscribeJobModal('noAvailableJobs')
     
     } else {
          $(".jobs-count").text(`Showing ${jobs.length} of ${totalCount} Jobs`);
     }
     
    renderPagination(totalCount, currentPage, onPageChange)
    
    $(".loader").removeClass("active");
  }
  
  
  
  function onPageChange(newPage) {
  $(".loader").addClass("active");

  fetchData("<?php echo $current_directory; ?>/oracle_api.php", {
    page: newPage,
    limit: 30
  })
  .done(handleApiResponse)
  .fail(handleError);
}


  function handleFilterResponse(data) {
    const parsedData = JSON.parse(data);
    const categories = parsedData.categories.sort((a, b) => a.localeCompare(b));
    const locations = parsedData.locations.sort((a, b) => a.localeCompare(b));
    const degreeLevels = parsedData.degreeLevels.sort((a, b) =>
      a.localeCompare(b)
    );

    renderDropdownOptions("#categories", categories);
    renderDropdownOptions(".locations", locations);
    renderDropdownOptions("#location-search", locations);
    renderDropdownOptions("#degreeLevels", degreeLevels);

    $(".loader").removeClass("active");
  }

  function handleError(xhr, status, error) {
    console.log(error);
  }

  var locationParams = [];
  var titleParams = [];
  var degreeParams = [];

  $("#job-search-form").on("submit", function (e) {
    e.preventDefault();
    const searchTerm = $("#search-keyword").val();
    const location = $("#location-search").val();

    updateURL(false);
  });

  function handlePageWithoutJobsPath() {
    // Fetch data based on extracted search term and location
    fetchData("<?php echo $current_directory; ?>/oracle_api.php")
      .done(handleApiResponse)
      .fail(handleError);
  }


  // fetchData("<?php echo $current_directory; ?>/oracle_api.php").done(handleApiResponse).fail(handleError);

  fetchData("<?php echo $current_directory; ?>/oracle_api_filters_data.php")
    .done(handleFilterResponse)
    .fail(handleError);


  function renderJobElements(jobs) {
    const container = $("#jobs-container");
    container.hide();
    container.empty();

    const showJobContainer = $(".tab-content");
    showJobContainer.hide();
    showJobContainer.empty();

    jobs.forEach((job, index) => {
      const jobElement = createJobElement(job, index);
    //   const jobDetailElement = createJobDetailElement(job, index);

      // Append to container
      container.append(jobElement);
    //   showJobContainer.append(jobDetailElement);
    });

    container.slideDown(500);
        attachScrollListenerAfterJobsLoad()
    // showJobContainer.slideDown(500);
    // $('.jobs-count').text(`${jobs.length} Jobs Found`);

    // Show job details based on URL job_id
    // const jobId = getJobIdFromUrl();
    // showJobDetails(jobId);
  }
  
  function createJobElement(job, index) {
    return `
             <div class="${index === 0 ? "active" : ""} bdr-1 job-container grid-item" 
                 id="v-pills-home-tab" 
                 data-bs-toggle="pill" 
                 data-job-id="${job.id}" 
                 data-job-title="${job.title}"
                 data-bs-target="#v-pills-jobcard-${job.id}" 
                 type="button" 
                 role="tab" 
                 aria-controls="v-pills-home" 
                 aria-selected="true">
             
             
             
                 
                 
                 
                 <div class="py-4 px-2">
                     <div class="row">
                         <div class="col-md-6 col-6"><button class="btn ${
                           job.jobType === "On-site"
                             ? "btn-on-site"
                             : "btn-remote"
                         }">${job.jobType || "On-site"}</button></div>
                         <div class="col-6 mx-0 p-0 my-auto fs-14 text-end">${
                           job.postedDate || "Date"
                         }</div>
                         <div class="col-md-12 text-center fw-700 mt-3">${
                           job.title || "Title"
                         }</div>
                          <div class="col-md-12 text-center fw-400 mb-3 fs-14 mt-1 text-grey d-flex justify-content-center align-items-center"> 
                          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
                                <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
                                <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
                            </svg>
                            &nbsp; ${job.primaryLocation}
                          </div>
                         
                         
                         
                         
                         
                         
                         
                         ${
                           job.skills && job.skills.length > 0
                             ? `
                             <div class="col-md-12">
                                 <div class="row justify-content-center">
                                     ${job.skills
                                       .map(
                                         (skill) =>
                                           `<div class="col-lg-2 col-5 bdr-2 text-center m-1 fs-12">${skill}</div>`
                                       )
                                       .join("")}
                                 </div>
                             </div>`
                             : ``
                         }
                         ${
                           job.externalPostedEndDate
                             ? `<div class="col-md-12 text-center"><p class="mb-0 mt-4 fs-12">Apply By : ${job.externalPostedEndDate}</p></div>`
                             : ``
                         }
                         ${
                           job.externalDescriptionStr
                             ? `
                             <div class="col-md-12">
                                 <p class="mb-0 mt-1 fs-12">
                                     ${
                                       job.externalDescriptionStr.length > 100
                                         ? `${job.externalDescriptionStr.substring(
                                             0,
                                             100
                                           )}...`
                                         : job.externalDescriptionStr
                                     }
                                 </p>
                             </div>`
                             : ""
                         }
                     </div>
                 </div>
             </div>
         `;
  }


  function renderDropdownOptions(elementId, options) {
    const dropdown = $(elementId);
    // dropdown.empty();
    options.forEach((option) => {
      dropdown.append(`<option value="${option}">${option}</option>`);
    });
  }

  $(document).on("click", ".share-job", function (e) {
    e.preventDefault();

    const jobId = $(this).data("job-id");

    const shareUrl =
      "<?php echo $current_directory; ?>/jobdetail_oracle.php?job_id=" + jobId;
    // Copy the URL to the clipboard
    navigator.clipboard
      .writeText(shareUrl)
      .then(() => {
        Swal.fire({
          title: "Success!",
          text: "Link copied to clipboard",
          icon: "success",
          confirmButtonText: "Cool",
        });
      })
      .catch((err) => {
        console.error("Failed to copy: ", err);
      });
  });

  $(document).on("click", ".job-container", function (e) {
    e.preventDefault();

    const jobId = $(this).data("job-id");
     const jobTitle = $(this)
      .data("job-title")
      .toLowerCase()
      .replace(/\s+/g, "-") // Replace spaces with dashes
      .replace(/[\/]+/g, "") // Remove all slashes "/"
      .replace(/-+/g, "-")
     .replace(/\.+/g, ""); // Replace multiple dashes with a single dash
      
      
    const newUrl =
      "<?php echo $current_directory; ?>/" + jobTitle + "-" + jobId;
      
       

    window.open(newUrl, "_blank");
  });

  function checkDeviceWidth() {
    var windowWidth = $(window).width();

    if (windowWidth < 1024) {
      $(document).on("click", ".job-container", function () {
        const jobId = $(this).data("job-id");

        const currentUrl =
          "<?php echo $current_directory; ?>/jobdetail_oracle.php?job_id=" +
          jobId; // Get the current URL

        window.location.href = currentUrl;
      });
    }
  }

  // Initial check on page load
  checkDeviceWidth();

  // Event listener for window resize
  $(window).resize(function () {
    checkDeviceWidth();
  });
});




</script>
