<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="robots" content="noindex, nofollow" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
<link rel="icon" href="/favicon.ico" type="image/x-icon">

<link rel="stylesheet" type="text/css" href="/cssnew/style.css">
<link rel="stylesheet" href="/icons/icons.css">


<!--<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>-->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<!-- Font Awesome Kit -->
<!--<script src="https://kit.fontawesome.com/4705edb7da.js" crossorigin="anonymous"></script>-->


<script>

$(document).ready(function() {$('#categories').select2({placeholder: 'Select Roles',width: '100%'});});
</script>
<script>
$(document).ready(function() {$('#state').select2({placeholder: 'Select State',width: '100%'});});
</script>
<script>
$(document).ready(function() {$('#city').select2({placeholder: 'Select City',width: '100%'});});
</script>
<script>
$(document).ready(function() {$('#location').select2({placeholder: 'Select Location',width: '100%'});});
</script>
<script>
$(document).ready(function() {$('#degreeLevels').select2({placeholder: 'Select Degree Levels',width: '100%'});});


document.addEventListener("DOMContentLoaded", function () {
    
    updateThePageJobsHeading()
    updateMainHeading()
    updateJobHeaderBackground()
    checkForHivelyScript()
    $(".full-loader-wrapper").addClass('d-none');
    
document.querySelectorAll('li').forEach(function(li) {
  li.addEventListener('click', function(e) {
    // Check if the <li> has a direct <a> child (not inside a submenu)
    const directLink = li.querySelector(':scope > a');

    // If it exists, and the click wasn't directly on a nested link, trigger the click
    if (directLink && e.target.tagName !== 'A') {
      directLink.click();
    }
  });
});



    
    
function updateJobHeaderBackground() {
    // Get the current path from the URL

    const currentPath = window.location.pathname;

    // Extract the country and role type from the URL path
    const pathParts = currentPath.split('/').filter(part => part !== '');

    // Assuming the structure: [country, role-type, 'jobs']
    const countryPart = pathParts[0].split('-')[0]; // Get the country (e.g., 'usa', 'canada', etc.)
    const rolePart = pathParts[0] ? pathParts[0].split('-')[1] : '';
    
   console.log(countryPart) 
      console.log(rolePart) 

    // Map countries and roles to specific background images
    const imageMapping = {
        'usa': {
            'consulting': 'url(/banner-images/consulting-usa-canada.jpg)',
            'corporate': 'url(/banner-images/corporate-usa-canada.jpg)'
        },
        'canada': {
            'consulting': 'url(/banner-images/consulting-usa-canada.jpg)',
            'corporate': 'url(/banner-images/corporate-usa-canada.jpg)'
        },
        'india': {
            'consulting': 'url(/banner-images/consulting-india.jpg)',
            'corporate': 'url(/banner-images/corporate-india.jpg)'
        },
        'philippines': {
            'consulting': 'url(/banner-images/consulting-philip.jpg)',
            'corporate': 'url(/banner-images/corporate-philip.jpg)' // Add corporate image for Philippines if needed
        }
    };

    // Get the background image based on country and role
    const backgroundImage = imageMapping[countryPart] ? imageMapping[countryPart][rolePart] : null;

    // If a valid background image is found, apply it
    const jobHeader = document.querySelector('.artech-job .jobheader');
    
     // If a valid background image is found, apply it
    const jobDetailHeader = document.querySelector('.artech-job .job-detail-header');
    
  
  
    
    if (jobHeader && backgroundImage) {
      
      
        jobHeader.style.backgroundRepeat = 'no-repeat';
        jobHeader.style.backgroundSize = 'cover';
        jobHeader.style.backgroundPosition = 'top';
        jobHeader.style.backgroundImage = `linear-gradient(to right, rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0) 70%), ${backgroundImage}`;

    }
    
    if (jobDetailHeader && backgroundImage) {
      
      
        jobDetailHeader.style.backgroundRepeat = 'no-repeat';
        jobDetailHeader.style.backgroundSize = 'cover';
        jobDetailHeader.style.backgroundPosition = 'top';
        jobDetailHeader.style.backgroundImage = `linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), ${backgroundImage}`;

    }
 
}


function checkForHivelyScript(){
     // Get the current path from the URL (e.g., "/canada-consulting-jobs")
    const currentPath = window.location.pathname;

    // Extract the path parts
    const pathParts = currentPath.split('/').filter(part => part !== '');

    // Further split the country and role type by hyphen
    const countryPart = pathParts[0].split('-')[0]; // First part is the country (e.g., 'canada')
    const rolePart = pathParts[0] ? pathParts[0].split('-')[1] : ''; // Second part (if exists), split by '-'
    
    const jobDivaHeader = document.getElementById('jobdivaheader');
    if(jobDivaHeader){
        if(rolePart.includes('consulting') && (countryPart.includes('usa') || countryPart.includes('canada'))) {
            jobDivaHeader.style.display ="block";
        } else {
            jobDivaHeader.style.display ="none";
        }
    }

    
}
    
function updateMainHeading() {
    // Get the current path from the URL (e.g., "/canada-consulting-jobs")
    const currentPath = window.location.pathname;

    // Extract the path parts
    const pathParts = currentPath.split('/').filter(part => part !== '');

    // Further split the country and role type by hyphen
    const countryPart = pathParts[0].split('-')[0]; // First part is the country (e.g., 'canada')
    const rolePart = pathParts[0] ? pathParts[0].split('-')[1] : ''; // Second part (if exists), split by '-'

    // Determine the role type based on the second part
    const roleType = rolePart.includes('consulting') ? 'Consultant Roles' : 
                     (rolePart.includes('corporate') ? 'Internal Careers' : 'Other');

    // Capitalize the first letter of the country (helper function)
    const capitalizeFirstLetter = (str) => {
        return str.charAt(0).toUpperCase() + str.slice(1).toLowerCase();
    };
    
    const countryName = countryPart == "usa" ? "U.S." : capitalizeFirstLetter(countryPart);

    // Create the dynamic heading text
    const headingText = `Explore ${roleType} in ${countryName == "U.S." ? "the U.S." : countryName }`;
    
    
    const breadcrumbJobTypeText = rolePart.includes('consulting') ? 'CONSULTANT OPPORTUNITIES' : 
                     (rolePart.includes('corporate') ? 'INTERNAL CAREERS' : 'Other');
                     
    const breadcrumbJobCountryText = countryName;
    

    // Update the main heading with the dynamically generated text
    const mainHeadingElement = document.getElementById('main-heading');
    if (mainHeadingElement) {
        mainHeadingElement.textContent = headingText;
    }
    
    

    const breadCrumbJobType = document.getElementById('breadcrumb-job-type');
    if (breadCrumbJobType) {
        breadCrumbJobType.textContent = breadcrumbJobTypeText;
        
        if(rolePart.includes('consulting')){
           breadCrumbJobType.href = "https://www.artech.com/careers-consulting-jobs/";
        } else {
           breadCrumbJobType.href = "https://www.artech.com/careers/";
        }
        
        
     
    }
    
     
    const breadCrumbJobCountry = document.getElementById('breadcrumb-job-country');
    if (breadCrumbJobCountry) {
        breadCrumbJobCountry.textContent =  breadcrumbJobCountryText.toUpperCase()+ ' JOBS';
    }
    
    
    
    const spanRole = document.getElementById('banner-description');
    
    
    if (spanRole) {
       if (rolePart.includes('consulting')) {
           spanRole.innerHTML = 'Join 11,500+ empowered consultants at Artech—and get the support,<br> reach, and freedom to shape your future with top clients.';
       } else if (rolePart.includes('corporate')) {
           spanRole.innerHTML = 'Join a high-performing team with global reach—where your<br> impact, growth, and recognition go hand in hand.';
       } else {
           spanRole.textContent = '';
       }
   }

}

// Call the function to update the heading
updateMainHeading();

    
    // Function to capitalize the first letter of the country
    function capitalizeFirstLetter(string) {
        return string.charAt(0).toUpperCase() + string.slice(1).toLowerCase();
    }
    
});






// function updateThePageJobsHeading() {
//     const urlObj = new URL(window.location.href);
//     const path = urlObj.pathname.split('/').filter(Boolean);
//     const params = new URLSearchParams(urlObj.search);

//     // Advanced capitalize with Roman numerals and acronyms
//     const capitalize = str => {
//         const upperWords = ['QA', 'UI', 'UX', 'HR', 'IT', 'II', 'III', 'IV', 'VI', 'VII', 'VIII', 'IX', 'X'];
//         return str
//             .replace(/-/g, ' ')
//             .split(' ')
//             .map(word => upperWords.includes(word.toUpperCase()) ? word.toUpperCase() : word.charAt(0).toUpperCase() + word.slice(1).toLowerCase())
//             .join(' ');
//     };

//     let categories = [], keywords = [], cities = [], states = [], countries = [];

//     if (params.has('category')) {
//         categories = params.get('category').split(',').map(capitalize);
//     }

//     if (params.has('keyword')) {
//         keywords = params.get('keyword').split(',').map(capitalize);
//     }

//     if (params.has('city')) {
//         cities = params.get('city').split(',').map(c => capitalize(c.trim()));
//     }

//     if (params.has('state')) {
//         states = params.get('state').split(',').map(s => s.trim().toUpperCase());
//     }

//     if (params.has('country')) {
//         countries = params.get('country').split(',').map(c => c.trim().toUpperCase());
//     }

//     let dynamicHeading = '';

//     // Append categories or keywords
//     if (categories.length) {
//         dynamicHeading += [...new Set(categories)].join(', ');
//     } else if (keywords.length) {
//         dynamicHeading += [...new Set(keywords)].join(', ');
//     }

//     // Handle city/state/country logic
//     let locationText = '';

//     const uniqueStates = [...new Set(states)];
//     const uniqueCountries = [...new Set(countries)];
//     const uniqueCities = [...new Set(cities)];

//     if (uniqueCities.length) {
//         if (uniqueStates.length === 1 && uniqueCountries.length === 1) {
//             locationText = `Jobs in ${uniqueCities.join(', ')}`;
//         } else {
//             let combined = [];
//             for (let i = 0; i < uniqueCities.length; i++) {
//                 const city = uniqueCities[i] || '';
//                 const state = states[i] || '';
//                 const country = countries[i] || '';
//                 const locationString = [city, state, country].filter(Boolean).join(', ');
//                 combined.push(locationString);
//             }
//             locationText = `Jobs in ${combined.join(' & ')}`;
//         }

//         if (dynamicHeading) dynamicHeading += ' ';
//         dynamicHeading += locationText;
//     }

//     // Fallback to path title if nothing from params
//     if (
//         path && path[1] && path[1].length > 1 &&
//         (!categories.length && !keywords.length && !cities.length && !states.length)
//     ) {
//         const pathTitle = capitalize(path[1].replace(/-/g, ' '));
//         dynamicHeading = pathTitle;
//     }

//     // console.log('heading is - ' + dynamicHeading);
//     document.querySelector(".page-text-heading").textContent = dynamicHeading;
// }



  function updateThePageJobsHeading() {
    const urlObj = new URL(window.location.href);
    const path = urlObj.pathname.split('/').filter(Boolean);
    const params = new URLSearchParams(urlObj.search);

    const capitalize = str => {
        const upperWords = ['QA', 'UI', 'UX', 'HR', 'IT', 'II', 'III', 'IV', 'VI', 'VII', 'VIII', 'IX', 'X'];
        return str
            .replace(/-/g, ' ')
            .split(' ')
            .map(word => upperWords.includes(word.toUpperCase()) ? word.toUpperCase() : word.charAt(0).toUpperCase() + word.slice(1).toLowerCase())
            .join(' ');
    };

    let categories = [], keywords = [], cities = [], states = [], countries = [], location = [];

    if (params.has('category')) {
        categories = params.get('category').split(',').map(capitalize);
    }

    if (params.has('keyword')) {
        keywords = params.get('keyword').split(',').map(capitalize);
    }

    if (params.has('location')) {
        location = params.get('location').split(',').map(loc => capitalize(loc.trim()));
    }

    if (params.has('city')) {
        cities = params.get('city').split(',').map(c => capitalize(c.trim()));
    }

    if (params.has('state')) {
        states = params.get('state').split(',').map(s => s.trim().toUpperCase());
    }

    if (params.has('country')) {
        countries = params.get('country').split(',').map(c => c.trim().toUpperCase());
    }

    let dynamicHeading = '';

    // Add category or keyword and the word "Jobs" only once
    if (categories.length) {
        dynamicHeading += [...new Set(categories)].join(', ') + ' Jobs';
    } else if (keywords.length) {
        dynamicHeading += [...new Set(keywords)].join(', ') + ' Jobs';
    }

    // Handle location (city, state, country or location param)
    let locationText = '';

    // If location param exists, treat it as location
    if (location.length) {
        locationText = `Jobs in ${location.join(' & ')}`;
    } else {
        // If city/state/country params exist
        const uniqueStates = [...new Set(states)];
        const uniqueCountries = [...new Set(countries)];
        const uniqueCities = [...new Set(cities)];

        if (uniqueCities.length) {
            if (uniqueStates.length === 1 && uniqueCountries.length === 1) {
                locationText = `Jobs in ${uniqueCities.join(', ')}`;
            } else {
                let combined = [];
                for (let i = 0; i < uniqueCities.length; i++) {
                    const city = uniqueCities[i] || '';
                    const state = states[i] || '';
                    const country = countries[i] || '';
                    const locationString = [city, state, country].filter(Boolean).join(', ');
                    combined.push(locationString);
                }
                locationText = `Jobs in ${combined.join(' & ')}`;
            }
        } else if (uniqueStates.length) {
            // Only state is present
            locationText = `Jobs in ${uniqueStates.join(', ')}`;
        }
    }

    // Add location text only if it's not empty
    if (locationText) {
        if (dynamicHeading) {
            dynamicHeading += ' '; // Add space if there's already a category or keyword
        }
        dynamicHeading += locationText;
    }

    // Fallback to path title if nothing from params
    if (
        path && path[1] && path[1].length > 1 &&
        (!categories.length && !keywords.length && !cities.length && !states.length && !location.length)
    ) {
        const pathTitle = capitalize(path[1].replace(/-/g, ' '));
        dynamicHeading = pathTitle;
    }

    // Set the dynamic heading text
    const pageTextHeading = document.querySelector(".page-text-heading");
    if (pageTextHeading) {
        pageTextHeading.textContent = dynamicHeading.replace("Jobs Jobs","Jobs");
    }
}







 

  function handleApiResponse(data) {
    const parsedData = JSON.parse(data);
    
    const jobs = parsedData.jobs;
    if (jobs.length == 0) {
      $("#no-job").css("display", "block");
      $(".list-scroll").css("display", "none");
    } else {
      $("#no-job").css("display", "none");
      $(".list-scroll").css("display", "block");
    }

    renderJobElements(jobs);

    $(".loader").removeClass("active");
  }

  function handleFilterResponse(data) {
    const parsedData = JSON.parse(data);
    const categories = parsedData.categories.sort((a, b) => a.localeCompare(b));
    const locations = parsedData.locations.sort((a, b) => a.localeCompare(b));
    const degreeLevels = parsedData.degreeLevels.sort((a, b) =>
      a.localeCompare(b)
    );

    renderDropdownOptions("#categories", categories);
    renderDropdownOptions(".locations", locations);
    renderDropdownOptions("#location-search", locations);
    renderDropdownOptions("#degreeLevels", degreeLevels);

    $(".loader").removeClass("active");
  }

  function handleError(xhr, status, error) {
    console.log(error);
  }



  

</script>

<style>
    select[multiple] option:hover {background:transparent;}
    select[multiple] option:checked {font-weight: 700 !important;background:transparent;}
    select::-webkit-scrollbar {width:5px; background: rgba(210, 210, 210, 1);border-radius:20px;}
    select::-webkit-scrollbar-thumb {background: rgba(37, 62, 145, 1);border-radius:20px;}
    
    .select2-container .select2-search--inline .select2-search__field {height:23px!important;}
   .select2-container--default .select2-selection--multiple {
    background-color: white;
    border: 1px solid rgba(210, 210, 210, 1)!important;
    border-radius: 15px!important;
    cursor: text;
    padding: 15px!important;
    position: relative;
}
.select2-results__option {
    padding: 6px 19px;
    font-size: 14px;
    user-select: none;
    color: #777777;
    -webkit-user-select: none;
}
.select2-container--open .select2-dropdown--below {
    border-radius: 18px;
    padding: 10px;}
    .select2-container--open .select2-dropdown--below::-webkit-scrollbar {width:5px; background: rgba(210, 210, 210, 1);border-radius:20px;}
    .select2-container--open .select2-dropdown--below::-webkit-scrollbar-thumb {background: rgba(37, 62, 145, 1);border-radius:20px;}
    .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
    cursor: default;
    padding-left: 2px;
    padding-right: 5px;
    font-size: 12px;
}

  .select2-container--open .select2-dropdown--below{
           padding:0px;
           
       }
       .select2-results{
           overflow:hidden;
           border-radius:15px;
       }
   .select2-dropdown.select2-dropdown--above{
        border-radius:15px;
   }
   
   .joblist-container{
    margin-bottom:2rem;
}
.artech-job .fs-14{
    font-size:14px;
}

.bold-text{
    font-weight:bold;
}

.flex-grid {
  display: flex;
  flex-wrap: wrap;
  gap: 20px; /* spacing between items */
}

.grid-item {
  flex: 0 0 calc(33.333% - 14px); /* 3 in a row with gap adjustment */
  padding: 20px;

}
#dynamic_title {
  white-space: nowrap;    
  overflow: hidden;         
  text-overflow: ellipsis;    
  max-width: 240px;        

}

.message-banner {
  width: 100%;
  background-color: #f5f8fa; /* light background */
  border: 1px solid #dbe2e8; /* subtle border */
  border-radius: 8px;
  padding: 20px;
  position: relative;
  margin: 20px auto;
  box-sizing: border-box;

}

.message-banner p {
  margin: 0;
  color: #333;
  font-size: 14px;
  line-height: 1.5;
}

.message-banner a {
  color: #007BFF;
  text-decoration: underline;
   font-size: 14px !important;
}

.message-banner-close-btn {
  position: absolute;
  top: 12px;
  right: 16px;
  font-size: 20px;
  font-weight: bold;
  color: #333;
  cursor: pointer;
  background: none;
  border: none;
  line-height: 1;
}

 .upload_dropZone.highlight {
    background-color: #f0f8ff;
    border: 2px dashed #4a90e2;
  }
  
  .full-loader-wrapper{
      top:0px;
      bottom:0px;
  }
  
  
  
  #hively-csat-banner{
    width: 100% !important;
    max-width: 100% !important;
    background-color:rgba(37, 62, 145, 1) !important;
    border-radius:0px !important;
  }
  
  #hively-csat-banner #cta h2 {
    color: #fff !important;
    margin-right: 22px;
    text-align: right;
}

#hively-csat-banner{
    border:none !important;
}

#hively-csat-banner #csat p {
    color: #fff !important;
    text-align: left !important;
}
#hively-csat-banner #csat p {
    font-size: 24px;
    margin: 0px 40px 0px 0px;
    color: #333;
}

#hively-csat-banner #attribution p{
    text-align:center !important;
}
#hively-csat-banner #attribution p a {
    color: #fff !important;
}

</style>

<?php

// The below code identifies the directory to be used in the api calls path
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$root_url = $protocol . "://" . $_SERVER['HTTP_HOST']; 
$current_directory = $root_url . dirname($_SERVER['PHP_SELF']);


?>

<!--<div class="loading-wrapper-full">-->
<!--    <span class="loader"></span>-->
<!--</div>-->