

    <div id="subscribeJobModal" style="
        display: none; 
        position: fixed; 
        top: 0; 
        left: 0; 
        width: 100%; 
        height: 100%; 
        background: rgba(0, 0, 0, 0.6); 
        z-index: 9999; 
        justify-content: center; 
        align-items: center; 
        padding: 20px; 
        box-sizing: border-box;
        overflow-y: auto;
    ">
      <div style="
          background: #fff; 
          padding: 40px 30px; 
          max-width: 600px; 
          width: 100%; 
          border-radius: 12px; 
          text-align: center; 
          box-shadow: 0 6px 20px rgba(0,0,0,0.1); 
          position: relative;
          animation: fadeInScale 0.3s ease;
      ">
        <button class="close-popup" onclick="closeSubscribeJobModal()">&#10005;</button>
        <h2 style="
            font-size: 26px; 
            font-weight: 700; 
            margin-bottom: 20px; 
            color: #333;
        ">Not seeing the right fit?</h2>
    
        <p style="
            font-size: 16px; 
            color: #666; 
            line-height: 1.6; 
            margin-bottom: 25px;
        ">
          Subscribe for updates on new roles that match your skills.
          <br>
        </p>
    
        <button style="
    
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s ease;
        " 
        class="btn btn-jl-common" 
        onclick="handleSubscribeJob()">
          Subscribe
        </button>
      </div>
    </div>
    <footer id="footer" class="dark-style">
      <div class="container">
        <div class="row footer-row">
          <div class="col-md-3 col-sm-12 widget-column">
            <div class="widget-item">
              <h4>OUR SOLUTIONS</h4>
              <ul class="menu">
                <li><a href="https://www.artech.com/staffing-agency-in-new-jersey-artech/">Contingent Staffing</a></li>
                <li><a href="https://www.artech.com/recruitment-process-outsourcing/">Recruitment Process Outsourcing (RPO)</a></li>
                <li><a href="https://www.artech.com/direct-hire/">Direct Hire</a></li>
                <li><a href="https://www.artech.com/master-vendor-program/">Master Vendor Program</a></li>
                <li><a href="https://www.artech.com/payroll-transition-services/">Payroll & Transition Services</a></li>
                <li><a href="https://www.artech.com/managed-services-and-project-delivery/">Managed Services and Project Delivery</a></li>
              </ul>
            </div>
          </div>
          <div class="col-md-3 col-sm-12 widget-column">
            <div class="widget-item">
              <h4>DIVERSITY & INCLUSION</h4>
            </div>
            <div class="widget-item">
              <h4>CAREERS</h4>
              <ul class="menu">
                <li><a href="https://www.artech.com/careers/corporate-employees/">Corporate Jobs</a></li>
                <li><a href="https://www.artech.com/careers/consultants/">Consultant Jobs</a></li>
              </ul>
            </div>
            <div class="widget-item">
              <h4 style="margin-top: 20px;color:#fff"><a style="text-decoration: none; color: #fff;" href="https://wjz.kqk.mybluehost.me/ArtechSTG11062024/community-first-initiatives/">COMMUNITY FIRST INITIATIVES</a></h4>
            </div>
          </div>
          <div class="col-md-3 col-sm-12 widget-column">
            <div class="widget-item">
              <h4>RESOURCES</h4>
              <ul class="menu">
                <li><a href="https://www.artech.com/articles/">Articles</a></li>
                <li><a href="https://www.artech.com/blog/">Blogs</a></li>
                <li><a href="https://www.artech.com/case-study/">Case Studies</a></li>
                <li><a href="#popmake-15335" class="pum-trigger">Notices</a></li>
                <li><a href="https://www.artech.com/faqs/">FAQs</a></li>
                <li><a href="https://www.artech.com/web-stories/">Web Stories</a></li>
              </ul>
            </div>
          </div>
          <div class="col-md-3 col-sm-12 widget-column">
            <div class="widget-item">
              <h4>ABOUT US</h4>
              <ul class="menu">
                <li><a href="https://www.artech.com/about-us/#Advantage">Artech Advantage</a></li>
                <li><a href="https://www.artech.com/about-us/#Work">Great Place to Work</a></li>
                <li><a href="https://www.artech.com/about-us/awards/">Awards</a></li>
                <li><a href="https://www.artech.com/about-us/#certifications">Certifications & Accolades</a></li>
              </ul>
            </div>
            <div class="widget-item">
              <h4 style="margin-top: 20px;">CONTACT US</h4>
            </div>
          </div>
        </div>
        <div class="custom-footer">
          <div class="row footer-row">
            <div class="col-md-8 col-sm-12 widget-column">
              <div class="contact-item widget-item">
                <h4>CONTACT US</h4>
                <ul class="menu">
                  <li><a href="https://www.artech.com/contact-us/#usa"><i class="icon-map-marker"></i> USA</a></li>
                  <li><a href="https://www.artech.com/contact-us/#canada"><i class="icon-map-marker"></i> Canada</a></li>
                  <li><a href="https://www.artech.com/contact-us/#india"><i class="icon-map-marker"></i> India</a></li>
                  <li><a href="https://www.artech.com/contact-us"><i class="icon-map-marker"></i> Philippines</a></li>
                </ul>
              </div>
            </div>
            <div class="col-md-4 col-sm-12 widget-column">
              <div class="widget-item footer-social-icons">
                <div class="social-box">
                    <h4 class="m-0">FOLLOW US</h4>
                    <ul class="social-icons">
                        <li class="linkedin">
                            <a href="https://www.linkedin.com/company/artechllc/" target="_blank" class="social-link linkedin">
                                <i class="icon-linkedin"></i>
                            </a>
                        </li>
                        <li class="fb">
                            <a href="https://www.facebook.com/ArtechLLC2" target="_blank" class="social-link facebook">
                                <i class="icon-facebook"></i>
                            </a>
                        </li>
                        <li class="twitter">
                            <a href="https://x.com/Artech_LLC" target="_blank" class="social-link twitter">
                                <img style="width: 16px;" src="/banner-images/twitter.png"/>
                            </a>
                        </li>
                        <li class="linkedin">
                            <a href="https://www.instagram.com/artechinfo/" target="_blank" class="social-link instagram">
                                <i class="icon-instagram"></i>
                            </a>
                        </li>
                    </ul>
                </div>
              </div>
            </div>
          </div>
        </div>

      
      </div>
      
    </footer>
    <!--<div id="copyright-wrapper" class="normal-copyright clearfix">-->
    <!--    <div class="container">-->
    <!--        <div id="copyright-text">-->
    <!--            <p class="mb-0">© 2025 · Artech LLC.</p>-->
    <!--        </div>-->
    <!--        <div id="footer-menu" class="clearfix">-->
    <!--            <ul id="footer-nav" class="mb-0">-->
    <!--                <li><a href="https://www.artech.com/sitemap/">Sitemap</a></li>-->
    <!--                <li><a href="https://www.artech.com/privacy-policy/">Privacy Policy</a></li>-->
    <!--                <li><a href="https://www.artech.com/terms-of-use/">Terms of Use</a></li>-->
    <!--                <li><a href="https://www.artech.com/artech-employee-online-forum-policy/">Artech Employee Online Forum Policy</a></li>-->
    <!--            </ul>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
    <div id="copyright-wrapper" class="container-fluid">
        <div id="copyright-text">
                <p class="mb-0">© 2025 · Artech LLC.</p>
            </div>
            <div id="footer-menu" class="clearfix">
                <ul id="footer-nav" class="mb-0">
                    <li><a href="https://www.artech.com/sitemap/">Sitemap</a></li>
                    <li><a href="https://www.artech.com/privacy-policy/">Privacy Policy</a></li>
                    <li><a href="https://www.artech.com/terms-of-use/">Terms of Use</a></li>
                    <li><a href="https://www.artech.com/artech-employee-online-forum-policy/">Artech Employee Online Forum Policy</a></li>
                </ul>
            </div>
    </div>
    

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

<script>
    function jltoggle() {
        var x = document.getElementById("contentBox");
        if (x.style.display == "none") {
            x.style.display = "block";
        } else {
            x.style.display = "none";
        }
    }
</script>
<script>
  function handleSubscribeJob() {
      const currentPath = window.location.pathname.split('/').slice(0, 2).join('/');
      window.location.href = `${currentPath}/subscription-form`;
  }

  window.addEventListener('load', function() {
    const section = document.querySelector('.fade-up');
    section?.classList.add('show');
  });
    
    
    
    
        // 98 Trigger: Scroll past 75%
function attachScrollListenerAfterJobsLoad() {
  let triggered = false;
  window.addEventListener('scroll', () => {
    const scrollTop = window.scrollY;
    const windowHeight = window.innerHeight;
    const docHeight = document.body.scrollHeight;
    const scrollPercent = (scrollTop + windowHeight) / docHeight;

    if (
      scrollPercent > 0.75 &&
      !triggered &&
      !sessionStorage.getItem(getSessionKey('scroll75'))
    ) {
      triggered = true;
      showSubscribeJobModal('scroll75');
    }
  });
}

    
</script>




<script>
const path = window.location.pathname;
const mainDir = path.split('/').filter(Boolean)[0]; // e.g., 'usa-consulting-jobs'

// 73 Function to generate unique session key for a specific trigger
function getSessionKey(reason) {
  return `jobPopupClosed_${reason}_${mainDir}`;
}

// 05 Show modal
function showSubscribeJobModal(reason) {
  document.getElementById('subscribeJobModal').style.display = 'flex';

  // Store the reason temporarily so close can refer to it
  document.getElementById('subscribeJobModal').dataset.reason = reason;
}




// 73 Mark as applied (optional, for separate use)
function setHasAppliedLocalStorage() {
  sessionStorage.setItem('hasApplied', 'true');
}

// 98 Trigger: After 120s inactivity
document.addEventListener("DOMContentLoaded", function () {
  setTimeout(() => {
    if (!sessionStorage.getItem(getSessionKey('inactivity120s'))) {
      showSubscribeJobModal('inactivity120s');
    }
  }, 120000);
});


// 01 Close modal and store only specific keys
function closeSubscribeJobModal() {
  const modal = document.getElementById('subscribeJobModal');
  modal.style.display = 'none';

  const reason = modal.dataset.reason || popupTriggerReason;

  if (reason) {
    sessionStorage.setItem(getSessionKey(reason), 'true');

    // Special handling: set localStorage timestamp only for returningVisitor
    if (reason === 'returningVisitor') {
      localStorage.setItem(getReturningVisitorCloseKey(), Date.now().toString());
    }
     // Handle viewedJobs
    if (reason === 'viewedJobs') {
      localStorage.setItem(getViewTriggerCloseKey(), Date.now().toString());
    }
  }
}


// 73 On first visit, mark user as returning visitor for this directory
window.addEventListener('load', () => {
  const flagKey = getReturningVisitorFlagKey();
  if (!localStorage.getItem(flagKey)) {
    localStorage.setItem(flagKey, 'true');
  }
});


// 75 LocalStorage key to mark a returning visitor
function getReturningVisitorFlagKey() {
  const path = window.location.pathname;
  const mainDir = path.split('/').filter(Boolean)[0];
  return `isReturningVisitor_${mainDir}`;
}


// 75 LocalStorage key to track when returning visitor popup was closed
function getReturningVisitorCloseKey() {
  const path = window.location.pathname;
  const mainDir = path.split('/').filter(Boolean)[0];
  return `jobPopupClosed_returningVisitor_${mainDir}`;
}


// 77 Check if returning visitor popup was recently closed (e.g., < 24 hours)
function wasReturningVisitorPopupRecentlyClosed() {
  const closedTimestamp = localStorage.getItem(getReturningVisitorCloseKey());
  if (!closedTimestamp) return false;
  const timeElapsed = Date.now() - parseInt(closedTimestamp, 10);
  return timeElapsed < 24 * 60 * 60 * 1000; // 24 hours
}


// 98 Trigger: Returning visitor who hasnt applied and hasnt closed this popup
if (
  document.getElementById('jobs-container') &&
  localStorage.getItem(getReturningVisitorFlagKey()) === 'true' &&
  !localStorage.getItem('hasApplied') &&
  !wasReturningVisitorPopupRecentlyClosed()
) {
  showSubscribeJobModal('returningVisitor');
}










// --------------------------------------
// 75 Get the subdirectory from path like `usa-consulting-jobs`
function getJobSection() {
  const path = window.location.pathname;
  return path.split('/').filter(Boolean)[0]; // "usa-consulting-jobs"
}

// 75 Key to track views per section
function getJobViewsKey() {
  return `jobViews_${getJobSection()}`;
}

// 75 Key to track when modal was closed for this trigger
function getViewTriggerCloseKey() {
  return `jobPopupClosed_viewedJobs_${getJobSection()}`;
}

// 77 Check if popup was closed for this reason recently (< 1 hour)
function wasViewedJobsPopupRecentlyClosed() {
  const closedTimestamp = localStorage.getItem(getViewTriggerCloseKey());
  if (!closedTimestamp) return false;
  const timeElapsed = Date.now() - parseInt(closedTimestamp, 10);
  return timeElapsed < 60 * 60 * 1000; // 1 hour
}

// 91 Track job views per section and trigger modal after 3+ views
function trackJobViewsAndTriggerModal() {
  const section = getJobSection();
  const viewsKey = getJobViewsKey();
  const now = Date.now();

  let views = JSON.parse(localStorage.getItem(viewsKey) || '[]');

  // Clean up views older than 1 hour
  views = views.filter((timestamp) => now - timestamp < 60 * 60 * 1000);

  // Add current view
  views.push(now);
  localStorage.setItem(viewsKey, JSON.stringify(views));

  if (
    views.length >= 3 &&
    !localStorage.getItem('hasApplied') &&
    !wasViewedJobsPopupRecentlyClosed()
  ) {
    showSubscribeJobModal('viewedJobs');
  }
}

// 98 Call on job detail pages only
if (document.querySelector('.job-detail-header')) {
  trackJobViewsAndTriggerModal();
}



</script>

















<script>

// subscription popup triggers end -----------------------------------------



document.addEventListener("DOMContentLoaded", function () {

    
    
  const toggleButton = document.getElementById("mobile-menu-toggle");
  const nav = document.querySelector(".main-navigation");

  toggleButton.addEventListener("click", function () {
    nav.classList.toggle("open");
  });
});


document.addEventListener("DOMContentLoaded", function () {
  const toggleButton = document.getElementById("close-nav");
  const nav = document.querySelector(".main-navigation");

  toggleButton.addEventListener("click", function () {
    nav.classList.toggle("open");
  });
});

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('.main-navigation li > a').forEach(link => {
    link.addEventListener('click', function (e) {
      const parentLi = this.parentElement;
      const submenu = parentLi.querySelector('.submenu');

      if (submenu) {
        e.preventDefault(); // Prevent link navigation
        submenu.classList.toggle('open'); // Toggle class
      }
    });
  });
});

</script>





